/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.vehicle_parking;

import java.io.Serializable;
import java.util.Objects;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class VehicleParkingEntrance
implements Serializable {
    private final VehicleParking vehicleParking;
    private final FeedScopedId entranceId;
    private final WgsCoordinate coordinate;
    private final I18NString name;
    private final boolean carAccessible;
    private final boolean walkAccessible;
    private transient StreetVertex vertex;

    VehicleParkingEntrance(VehicleParking vehicleParking, FeedScopedId entranceId, WgsCoordinate coordinate, I18NString name, StreetVertex vertex, boolean carAccessible, boolean walkAccessible) {
        this.vehicleParking = vehicleParking;
        this.entranceId = entranceId;
        this.coordinate = coordinate;
        this.name = name;
        this.vertex = vertex;
        this.carAccessible = carAccessible;
        this.walkAccessible = walkAccessible;
    }

    public static VehicleParkingEntranceBuilder builder() {
        return new VehicleParkingEntranceBuilder();
    }

    public VehicleParking getVehicleParking() {
        return this.vehicleParking;
    }

    public FeedScopedId getEntranceId() {
        return this.entranceId;
    }

    public WgsCoordinate getCoordinate() {
        return this.coordinate;
    }

    public I18NString getName() {
        return this.name;
    }

    public StreetVertex getVertex() {
        return this.vertex;
    }

    public boolean isCarAccessible() {
        return this.carAccessible;
    }

    public boolean isWalkAccessible() {
        return this.walkAccessible;
    }

    public int hashCode() {
        return Objects.hash(this.entranceId, this.coordinate, this.name, this.carAccessible, this.walkAccessible);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleParkingEntrance that = (VehicleParkingEntrance)o;
        return Objects.equals(this.coordinate, that.coordinate) && this.carAccessible == that.carAccessible && this.walkAccessible == that.walkAccessible && Objects.equals(this.entranceId, that.entranceId) && Objects.equals(this.name, that.name);
    }

    public String toString() {
        return ToStringBuilder.of(VehicleParkingEntrance.class).addObj("entranceId", this.entranceId).addObj("name", this.name).addObj("coordinate", this.coordinate).addBool("carAccessible", this.carAccessible).addBool("walkAccessible", this.walkAccessible).toString();
    }

    void clearVertex() {
        this.vertex = null;
    }

    public static class VehicleParkingEntranceBuilder {
        private VehicleParking vehicleParking;
        private FeedScopedId entranceId;
        private WgsCoordinate coordinate;
        private I18NString name;
        private StreetVertex vertex;
        private boolean carAccessible;
        private boolean walkAccessible;

        VehicleParkingEntranceBuilder() {
        }

        public VehicleParkingEntranceBuilder vehicleParking(VehicleParking vehicleParking) {
            this.vehicleParking = vehicleParking;
            return this;
        }

        public VehicleParkingEntranceBuilder entranceId(FeedScopedId entranceId) {
            this.entranceId = entranceId;
            return this;
        }

        public VehicleParkingEntranceBuilder coordinate(WgsCoordinate coordinate) {
            this.coordinate = coordinate;
            return this;
        }

        public VehicleParkingEntranceBuilder name(I18NString name) {
            this.name = name;
            return this;
        }

        public VehicleParkingEntranceBuilder vertex(StreetVertex vertex) {
            this.vertex = vertex;
            return this;
        }

        public VehicleParkingEntranceBuilder carAccessible(boolean carAccessible) {
            this.carAccessible = carAccessible;
            return this;
        }

        public VehicleParkingEntranceBuilder walkAccessible(boolean walkAccessible) {
            this.walkAccessible = walkAccessible;
            return this;
        }

        public VehicleParkingEntrance build() {
            return new VehicleParkingEntrance(this.vehicleParking, this.entranceId, this.coordinate, this.name, this.vertex, this.carAccessible, this.walkAccessible);
        }
    }
}

