/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.opentripplanner.routing.util.DiffEntry;
import org.opentripplanner.routing.util.DiffList;

public final class DiffTool {
    private DiffTool() {
    }

    public static <T> DiffList<T> diff(Collection<T> left, Collection<T> right, Comparator<T> comparator) {
        DiffList result = new DiffList();
        Iterator leftIterator = left.stream().sorted(comparator).iterator();
        Iterator rightIterator = right.stream().sorted(comparator).iterator();
        Object l = DiffTool.next(leftIterator);
        Object r = DiffTool.next(rightIterator);
        while (l != null && r != null) {
            int c = comparator.compare(l, r);
            if (c < 0) {
                result.add(DiffEntry.ofLeft(l));
                l = DiffTool.next(leftIterator);
                continue;
            }
            if (c > 0) {
                result.add(DiffEntry.ofRight(r));
                r = DiffTool.next(rightIterator);
                continue;
            }
            result.add(DiffEntry.ofEqual(l, r));
            l = DiffTool.next(leftIterator);
            r = DiffTool.next(rightIterator);
        }
        while (l != null) {
            result.add(DiffEntry.ofLeft(l));
            l = DiffTool.next(leftIterator);
        }
        while (r != null) {
            result.add(DiffEntry.ofRight(r));
            r = DiffTool.next(rightIterator);
        }
        return result;
    }

    @Nullable
    private static <T> T next(Iterator<T> it) {
        return it.hasNext() ? (T)it.next() : null;
    }
}

