/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.service;

import java.time.ZoneId;
import org.opentripplanner.routing.algorithm.RoutingWorker;
import org.opentripplanner.routing.algorithm.via.ViaRoutingWorker;
import org.opentripplanner.routing.api.RoutingService;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.RouteViaRequest;
import org.opentripplanner.routing.api.response.RoutingResponse;
import org.opentripplanner.routing.api.response.ViaRoutingResponse;
import org.opentripplanner.standalone.api.OtpServerRequestContext;

public class DefaultRoutingService
implements RoutingService {
    private final OtpServerRequestContext serverContext;
    private final ZoneId timeZone;

    public DefaultRoutingService(OtpServerRequestContext serverContext) {
        this.serverContext = serverContext;
        this.timeZone = serverContext.transitService().getTimeZone();
    }

    @Override
    public RoutingResponse route(RouteRequest request) {
        RoutingWorker worker = new RoutingWorker(this.serverContext, request, this.timeZone);
        return worker.route();
    }

    @Override
    public ViaRoutingResponse route(RouteViaRequest request) {
        ViaRoutingWorker viaRoutingWorker = new ViaRoutingWorker(request, req -> new RoutingWorker(this.serverContext, (RouteRequest)req, this.serverContext.transitService().getTimeZone()).route());
        return viaRoutingWorker.route();
    }
}

