/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.linking;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.index.EdgeSpatialIndex;
import org.opentripplanner.routing.linking.DisposableEdgeCollection;
import org.opentripplanner.routing.linking.FlexLocationAdder;
import org.opentripplanner.routing.linking.LinkingDirection;
import org.opentripplanner.routing.linking.Scope;
import org.opentripplanner.street.model.edge.AreaEdge;
import org.opentripplanner.street.model.edge.AreaEdgeList;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.NamedArea;
import org.opentripplanner.street.model.edge.SplitStreetEdge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.model.vertex.SplitterVertex;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.TemporarySplitterVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.TraverseModeSet;
import org.opentripplanner.transit.service.StopModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexLinker {
    private static final Logger LOG = LoggerFactory.getLogger(VertexLinker.class);
    private static final double DUPLICATE_WAY_EPSILON_METERS = 0.001;
    private static final int INITIAL_SEARCH_RADIUS_METERS = 100;
    private static final int MAX_SEARCH_RADIUS_METERS = 1000;
    private static final GeometryFactory GEOMETRY_FACTORY = GeometryUtils.getGeometryFactory();
    private final EdgeSpatialIndex edgeSpatialIndex;
    private final Graph graph;
    private final StopModel stopModel;
    private Boolean addExtraEdgesToAreas = true;

    public VertexLinker(Graph graph, StopModel stopModel, EdgeSpatialIndex edgeSpatialIndex) {
        this.edgeSpatialIndex = edgeSpatialIndex;
        this.graph = graph;
        this.stopModel = stopModel;
    }

    public void linkVertexPermanently(Vertex vertex, TraverseModeSet traverseModes, LinkingDirection direction, BiFunction<Vertex, StreetVertex, List<Edge>> edgeFunction) {
        this.link(vertex, traverseModes, direction, Scope.PERMANENT, edgeFunction);
    }

    public DisposableEdgeCollection linkVertexForRealTime(Vertex vertex, TraverseModeSet traverseModes, LinkingDirection direction, BiFunction<Vertex, StreetVertex, List<Edge>> edgeFunction) {
        return this.link(vertex, traverseModes, direction, Scope.REALTIME, edgeFunction);
    }

    public DisposableEdgeCollection linkVertexForRequest(Vertex vertex, TraverseModeSet traverseModes, LinkingDirection direction, BiFunction<Vertex, StreetVertex, List<Edge>> edgeFunction) {
        return this.link(vertex, traverseModes, direction, Scope.REQUEST, edgeFunction);
    }

    public void removeEdgeFromIndex(Edge edge, Scope scope) {
        if (edge.getGeometry() != null) {
            this.edgeSpatialIndex.remove(edge.getGeometry().getEnvelopeInternal(), edge, scope);
        }
    }

    public void removePermanentEdgeFromIndex(Edge edge) {
        this.removeEdgeFromIndex(edge, Scope.PERMANENT);
    }

    public void setAddExtraEdgesToAreas(Boolean addExtraEdgesToAreas) {
        this.addExtraEdgesToAreas = addExtraEdgesToAreas;
    }

    private static boolean edgeReachableFromGraph(Edge edge) {
        boolean edgeReachableFromGraph = edge.getToVertex().getIncoming().contains(edge);
        if (!edgeReachableFromGraph) {
            LOG.error("Edge returned from spatial index is no longer reachable from graph. That is not expected.");
        }
        return edgeReachableFromGraph;
    }

    private static double distance(Vertex tstop, StreetEdge edge, double xscale) {
        LineString transformed = VertexLinker.equirectangularProject(edge.getGeometry(), xscale);
        return transformed.distance((Geometry)GEOMETRY_FACTORY.createPoint(new Coordinate(tstop.getLon() * xscale, tstop.getLat())));
    }

    private static LineString equirectangularProject(LineString geometry, double xScale) {
        Coordinate[] coords = new Coordinate[geometry.getNumPoints()];
        for (int i = 0; i < coords.length; ++i) {
            Coordinate c = geometry.getCoordinateN(i);
            c = (Coordinate)c.clone();
            c.x *= xScale;
            coords[i] = c;
        }
        return GEOMETRY_FACTORY.createLineString(coords);
    }

    private DisposableEdgeCollection link(Vertex vertex, TraverseModeSet traverseModes, LinkingDirection direction, Scope scope, BiFunction<Vertex, StreetVertex, List<Edge>> edgeFunction) {
        DisposableEdgeCollection tempEdges = scope != Scope.PERMANENT ? new DisposableEdgeCollection(this.graph, scope) : null;
        try {
            Set<StreetVertex> streetVertices = this.linkToStreetEdges(vertex, traverseModes, direction, scope, 100, tempEdges);
            if (streetVertices.isEmpty()) {
                streetVertices = this.linkToStreetEdges(vertex, traverseModes, direction, scope, 1000, tempEdges);
            }
            for (StreetVertex streetVertex : streetVertices) {
                List<Edge> edges = edgeFunction.apply(vertex, streetVertex);
                if (tempEdges == null) continue;
                for (Edge edge : edges) {
                    tempEdges.addEdge(edge);
                }
            }
        }
        catch (Exception e) {
            if (tempEdges != null) {
                tempEdges.disposeEdges();
            }
            throw e;
        }
        return tempEdges;
    }

    private Set<StreetVertex> linkToStreetEdges(Vertex vertex, TraverseModeSet traverseModes, LinkingDirection direction, Scope scope, int radiusMeters, DisposableEdgeCollection tempEdges) {
        double radiusDeg = SphericalDistanceLibrary.metersToDegrees(radiusMeters);
        Envelope env = new Envelope(vertex.getCoordinate());
        double xscale = Math.cos(vertex.getLat() * Math.PI / 180.0);
        env.expandBy(radiusDeg / xscale, radiusDeg);
        List<DistanceTo<StreetEdge>> candidateEdges = this.edgeSpatialIndex.query(env, scope).filter(StreetEdge.class::isInstance).map(StreetEdge.class::cast).filter(e -> e.canTraverse(traverseModes) && VertexLinker.edgeReachableFromGraph(e)).map(e -> new DistanceTo<StreetEdge>((StreetEdge)e, VertexLinker.distance(vertex, e, xscale))).filter(ead -> ead.distanceDegreesLat < radiusDeg).collect(Collectors.toList());
        if (candidateEdges.isEmpty()) {
            return Set.of();
        }
        Set<DistanceTo<StreetEdge>> closestEdges = this.getClosestEdgesPerMode(traverseModes, candidateEdges);
        HashSet linkedAreas = new HashSet();
        return closestEdges.stream().map(ce -> this.link(vertex, (StreetEdge)ce.item, xscale, scope, direction, tempEdges, linkedAreas)).filter(v -> v != null).collect(Collectors.toSet());
    }

    private Set<DistanceTo<StreetEdge>> getClosestEdgesPerMode(TraverseModeSet traverseModeSet, List<DistanceTo<StreetEdge>> candidateEdges) {
        double DUPLICATE_WAY_EPSILON_DEGREES = SphericalDistanceLibrary.metersToDegrees(0.001);
        HashSet<DistanceTo<StreetEdge>> closesEdges = new HashSet<DistanceTo<StreetEdge>>();
        for (TraverseMode mode : traverseModeSet.getModes()) {
            TraverseModeSet modeSet = new TraverseModeSet(mode);
            List<DistanceTo> candidateEdgesForMode = candidateEdges.stream().filter(e -> ((StreetEdge)e.item).canTraverse(modeSet)).toList();
            if (candidateEdgesForMode.isEmpty()) continue;
            double closestDistance = candidateEdgesForMode.stream().mapToDouble(ce -> ce.distanceDegreesLat).min().getAsDouble();
            closesEdges.addAll(candidateEdges.stream().filter(ce -> ce.distanceDegreesLat <= closestDistance + DUPLICATE_WAY_EPSILON_DEGREES).collect(Collectors.toSet()));
        }
        return closesEdges;
    }

    private StreetVertex link(Vertex vertex, StreetEdge edge, double xScale, Scope scope, LinkingDirection direction, DisposableEdgeCollection tempEdges, Set<AreaEdgeList> linkedAreas) {
        LineString orig = edge.getGeometry();
        LineString transformed = VertexLinker.equirectangularProject(orig, xScale);
        LocationIndexedLine il = new LocationIndexedLine((Geometry)transformed);
        LinearLocation ll = il.project(new Coordinate(vertex.getLon() * xScale, vertex.getLat()));
        double length = SphericalDistanceLibrary.length(orig);
        IntersectionVertex start = null;
        if (ll.getSegmentIndex() == 0 && (ll.getSegmentFraction() < 1.0E-8 || ll.getSegmentFraction() * length < 0.1)) {
            start = (IntersectionVertex)edge.getFromVertex();
        } else if (ll.getSegmentIndex() == orig.getNumPoints() - 1) {
            start = (IntersectionVertex)edge.getToVertex();
        } else if (ll.getSegmentIndex() == orig.getNumPoints() - 2 && (ll.getSegmentFraction() > 0.99999999 || (1.0 - ll.getSegmentFraction()) * length < 0.1)) {
            start = (IntersectionVertex)edge.getToVertex();
        } else {
            AreaEdge aEdge;
            AreaEdgeList ael;
            boolean split = true;
            if (this.addExtraEdgesToAreas.booleanValue() && edge instanceof AreaEdge && (ael = (aEdge = (AreaEdge)edge).getArea()).getGeometry().contains((Geometry)GEOMETRY_FACTORY.createPoint(vertex.getCoordinate()))) {
                IntersectionVertex iv;
                if (!linkedAreas.add(ael)) {
                    return null;
                }
                start = vertex instanceof IntersectionVertex ? (iv = (IntersectionVertex)vertex) : this.splitVertex(aEdge, scope, direction, vertex.getLon(), vertex.getLat());
                split = false;
            }
            if (split) {
                start = this.split(edge, ll, scope, direction, tempEdges);
            }
        }
        if (this.addExtraEdgesToAreas.booleanValue() && edge instanceof AreaEdge) {
            AreaEdge aEdge = (AreaEdge)edge;
            this.addAreaVertex(start, aEdge.getArea(), scope, tempEdges);
        }
        if (OTPFeature.FlexRouting.isOn()) {
            FlexLocationAdder.addFlexLocations(edge, start, this.stopModel);
        }
        return start;
    }

    private SplitterVertex split(StreetEdge originalEdge, LinearLocation ll, Scope scope, LinkingDirection direction, DisposableEdgeCollection tempEdges) {
        SplitStreetEdge newEdges;
        LineString geometry = originalEdge.getGeometry();
        Coordinate splitPoint = ll.getCoordinate((Geometry)geometry);
        SplitterVertex v = this.splitVertex(originalEdge, scope, direction, splitPoint.x, splitPoint.y);
        SplitStreetEdge splitStreetEdge = newEdges = scope == Scope.PERMANENT ? originalEdge.splitDestructively(v) : originalEdge.splitNonDestructively(v, tempEdges, direction);
        if (scope == Scope.REALTIME || scope == Scope.PERMANENT) {
            if (newEdges.head() != null) {
                this.edgeSpatialIndex.insert(newEdges.head().getGeometry(), newEdges.head(), scope);
            }
            if (newEdges.tail() != null) {
                this.edgeSpatialIndex.insert(newEdges.tail().getGeometry(), newEdges.tail(), scope);
            }
            if (scope == Scope.PERMANENT) {
                this.removeEdgeFromIndex(originalEdge, scope);
                this.graph.removeEdge(originalEdge);
            }
        }
        return v;
    }

    private SplitterVertex splitVertex(StreetEdge originalEdge, Scope scope, LinkingDirection direction, double x, double y) {
        SplitterVertex v;
        String uniqueSplitLabel = "split_" + this.graph.nextSplitNumber++;
        if (scope != Scope.PERMANENT) {
            TemporarySplitterVertex tsv = new TemporarySplitterVertex(uniqueSplitLabel, x, y, originalEdge, direction == LinkingDirection.OUTGOING);
            tsv.setWheelchairAccessible(originalEdge.isWheelchairAccessible());
            v = tsv;
        } else {
            v = new SplitterVertex(this.graph, uniqueSplitLabel, x, y, originalEdge.getName());
        }
        v.addRentalRestriction(originalEdge.getFromVertex().rentalRestrictions());
        v.addRentalRestriction(originalEdge.getToVertex().rentalRestrictions());
        return v;
    }

    public void addPermanentAreaVertex(IntersectionVertex newVertex, AreaEdgeList edgeList) {
        this.addAreaVertex(newVertex, edgeList, Scope.PERMANENT, null);
    }

    public void addAreaVertex(IntersectionVertex newVertex, AreaEdgeList edgeList, Scope scope, DisposableEdgeCollection tempEdges) {
        List<NamedArea> areas = edgeList.getAreas();
        Geometry origPolygon = edgeList.getGeometry();
        Geometry polygon = origPolygon.union(origPolygon.getBoundary()).buffer(1.0E-6);
        HashSet<IntersectionVertex> visibilityVertices = edgeList.visibilityVertices;
        Coordinate[] nearestPoints = DistanceOp.nearestPoints((Geometry)polygon, (Geometry)GEOMETRY_FACTORY.createPoint(newVertex.getCoordinate()));
        int added = 0;
        for (IntersectionVertex v : visibilityVertices) {
            LineString newGeometry = GEOMETRY_FACTORY.createLineString(new Coordinate[]{nearestPoints[0], v.getCoordinate()});
            if (!polygon.contains((Geometry)newGeometry)) continue;
            this.createSegments(newVertex, v, edgeList, areas, scope, tempEdges);
            ++added;
        }
        if (added == 0) {
            for (IntersectionVertex v : visibilityVertices) {
                this.createSegments(newVertex, v, edgeList, areas, scope, tempEdges);
            }
        }
        if (scope == Scope.PERMANENT) {
            visibilityVertices.add(newVertex);
        }
    }

    private void createSegments(IntersectionVertex from, IntersectionVertex to, AreaEdgeList ael, List<NamedArea> areas, Scope scope, DisposableEdgeCollection tempEdges) {
        if (from.isConnected(to)) {
            return;
        }
        LineString line = GEOMETRY_FACTORY.createLineString(new Coordinate[]{from.getCoordinate(), to.getCoordinate()});
        ArrayList intersects = new ArrayList();
        NamedArea hit = null;
        for (NamedArea area : areas) {
            Geometry polygon = area.getPolygon();
            Geometry intersection = polygon.intersection((Geometry)line);
            if (!(intersection.getLength() > 1.0E-6)) continue;
            hit = area;
            break;
        }
        if (hit != null) {
            double length = SphericalDistanceLibrary.distance(to.getCoordinate(), from.getCoordinate());
            AreaEdge ae = new AreaEdge(from, to, line, hit.getName(), length, hit.getPermission(), false, ael);
            if (scope != Scope.PERMANENT) {
                tempEdges.addEdge(ae);
            }
            ae = new AreaEdge(to, from, line.reverse(), hit.getName(), length, hit.getPermission(), true, ael);
            if (scope != Scope.PERMANENT) {
                tempEdges.addEdge(ae);
            }
        }
    }

    private static class DistanceTo<T> {
        T item;
        double distanceDegreesLat;

        public DistanceTo(T item, double distanceDegreesLat) {
            this.item = item;
            this.distanceDegreesLat = distanceDegreesLat;
        }

        public int hashCode() {
            return Objects.hash(this.item);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DistanceTo that = (DistanceTo)o;
            return Objects.equals(this.item, that.item);
        }
    }

    private record StreetEdgePair(StreetEdge e0, StreetEdge e1) {
    }
}

