/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.opentripplanner.routing.alertpatch.EntityKey;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.StopCondition;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.timetable.Direction;
import org.opentripplanner.transit.service.TransitModel;

public class TransitAlertServiceImpl
implements TransitAlertService {
    private final TransitModel transitModel;
    private Multimap<EntityKey, TransitAlert> alerts = HashMultimap.create();

    public TransitAlertServiceImpl(TransitModel transitModel) {
        this.transitModel = transitModel;
    }

    @Override
    public void setAlerts(Collection<TransitAlert> alerts) {
        HashMultimap newAlerts = HashMultimap.create();
        for (TransitAlert alert : alerts) {
            for (EntitySelector entity : alert.entities()) {
                newAlerts.put((Object)entity.key(), (Object)alert);
            }
        }
        this.alerts = newAlerts;
    }

    @Override
    public Collection<TransitAlert> getAllAlerts() {
        return new HashSet<TransitAlert>(this.alerts.values());
    }

    @Override
    public TransitAlert getAlertById(FeedScopedId id) {
        return this.alerts.values().stream().filter(transitAlert -> transitAlert.getId().equals(id)).findAny().orElse(null);
    }

    @Override
    public Collection<TransitAlert> getStopAlerts(FeedScopedId stopId, Set<StopCondition> stopConditions) {
        RegularStop quay;
        HashSet<TransitAlert> result = new HashSet<TransitAlert>();
        EntitySelector.Stop entitySelector = new EntitySelector.Stop(stopId, stopConditions);
        for (TransitAlert alert : this.alerts.get((Object)entitySelector.key())) {
            if (!alert.entities().stream().anyMatch(selector -> selector.matches(entitySelector))) continue;
            result.add(alert);
        }
        if (!result.isEmpty() || this.transitModel == null || (quay = this.transitModel.getStopModel().getRegularStop(stopId)) != null) {
            // empty if block
        }
        return result;
    }

    @Override
    public Collection<TransitAlert> getRouteAlerts(FeedScopedId route) {
        return this.alerts.get((Object)new EntityKey.Route(route));
    }

    @Override
    public Collection<TransitAlert> getTripAlerts(FeedScopedId trip, LocalDate serviceDate) {
        HashSet<TransitAlert> result = new HashSet<TransitAlert>();
        EntitySelector.Trip entitySelector = new EntitySelector.Trip(trip, serviceDate);
        for (TransitAlert alert : this.alerts.get((Object)entitySelector.key())) {
            if (!alert.entities().stream().anyMatch(selector -> selector.matches(entitySelector))) continue;
            result.add(alert);
        }
        return result;
    }

    @Override
    public Collection<TransitAlert> getAgencyAlerts(FeedScopedId agency) {
        return this.alerts.get((Object)new EntityKey.Agency(agency));
    }

    @Override
    public Collection<TransitAlert> getStopAndRouteAlerts(FeedScopedId stop, FeedScopedId route, Set<StopCondition> stopConditions) {
        HashSet<TransitAlert> result = new HashSet<TransitAlert>();
        EntitySelector.StopAndRoute entitySelector = new EntitySelector.StopAndRoute(stop, route, stopConditions);
        for (TransitAlert alert : this.alerts.get((Object)entitySelector.key())) {
            if (!alert.entities().stream().anyMatch(selector -> selector.matches(entitySelector))) continue;
            result.add(alert);
        }
        return result;
    }

    @Override
    public Collection<TransitAlert> getStopAndTripAlerts(FeedScopedId stop, FeedScopedId trip, LocalDate serviceDate, Set<StopCondition> stopConditions) {
        HashSet<TransitAlert> result = new HashSet<TransitAlert>();
        EntitySelector.StopAndTrip entitySelector = new EntitySelector.StopAndTrip(stop, trip, serviceDate, stopConditions);
        for (TransitAlert alert : this.alerts.get((Object)entitySelector.key())) {
            if (!alert.entities().stream().anyMatch(selector -> selector.matches(entitySelector))) continue;
            result.add(alert);
        }
        return result;
    }

    @Override
    public Collection<TransitAlert> getRouteTypeAndAgencyAlerts(int routeType, FeedScopedId agency) {
        return this.alerts.get((Object)new EntityKey.RouteTypeAndAgency(agency, routeType));
    }

    @Override
    public Collection<TransitAlert> getRouteTypeAlerts(int routeType, String feedId) {
        return this.alerts.get((Object)new EntityKey.RouteType(feedId, routeType));
    }

    @Override
    public Collection<TransitAlert> getDirectionAndRouteAlerts(Direction direction, FeedScopedId route) {
        return this.alerts.get((Object)new EntityKey.DirectionAndRoute(route, direction));
    }
}

