/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graphfinder;

import java.util.Comparator;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.astar.spi.SkipEdgeStrategy;
import org.opentripplanner.astar.spi.TraverseVisitor;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graphfinder.GraphFinder;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.graphfinder.PlaceAtDistance;
import org.opentripplanner.routing.graphfinder.PlaceFinderTraverseVisitor;
import org.opentripplanner.routing.graphfinder.PlaceType;
import org.opentripplanner.routing.graphfinder.StopFinderTraverseVisitor;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.search.StreetSearchBuilder;
import org.opentripplanner.street.search.TemporaryVerticesContainer;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.strategy.DominanceFunctions;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.service.TransitService;

public class StreetGraphFinder
implements GraphFinder {
    private final Graph graph;

    public StreetGraphFinder(Graph graph) {
        this.graph = graph;
    }

    @Override
    public List<NearbyStop> findClosestStops(Coordinate coordinate, double radiusMeters) {
        StopFinderTraverseVisitor visitor = new StopFinderTraverseVisitor(radiusMeters);
        this.findClosestUsingStreets(coordinate.getY(), coordinate.getX(), visitor, visitor.getSkipEdgeStrategy());
        return visitor.stopsFound;
    }

    @Override
    public List<PlaceAtDistance> findClosestPlaces(double lat, double lon, double radiusMeters, int maxResults, List<TransitMode> filterByModes, List<PlaceType> filterByPlaceTypes, List<FeedScopedId> filterByStops, List<FeedScopedId> filterByRoutes, List<String> filterByBikeRentalStations, TransitService transitService) {
        PlaceFinderTraverseVisitor visitor = new PlaceFinderTraverseVisitor(transitService, filterByModes, filterByPlaceTypes, filterByStops, filterByRoutes, filterByBikeRentalStations, maxResults, radiusMeters);
        SkipEdgeStrategy<State, Edge> terminationStrategy = visitor.getSkipEdgeStrategy();
        this.findClosestUsingStreets(lat, lon, visitor, terminationStrategy);
        List<PlaceAtDistance> results = visitor.placesFound;
        results.sort(Comparator.comparingDouble(PlaceAtDistance::distance));
        return results.subList(0, Integer.min(results.size(), maxResults));
    }

    private void findClosestUsingStreets(double lat, double lon, TraverseVisitor<State, Edge> visitor, SkipEdgeStrategy<State, Edge> skipEdgeStrategy) {
        RouteRequest rr = new RouteRequest();
        rr.setFrom(new GenericLocation(null, null, lat, lon));
        rr.withPreferences(pref -> pref.withWalk(it -> it.withSpeed(1.0)));
        rr.setNumItineraries(1);
        try (TemporaryVerticesContainer temporaryVertices = new TemporaryVerticesContainer(this.graph, rr, StreetMode.WALK, StreetMode.WALK);){
            ((StreetSearchBuilder)((StreetSearchBuilder)((StreetSearchBuilder)StreetSearchBuilder.of().setSkipEdgeStrategy(skipEdgeStrategy)).setTraverseVisitor(visitor)).setDominanceFunction(new DominanceFunctions.LeastWalk())).setRequest(rr).setVerticesContainer(temporaryVertices).getShortestPathTree();
        }
    }
}

