/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graphfinder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.astar.spi.SkipEdgeStrategy;
import org.opentripplanner.astar.spi.TraverseVisitor;
import org.opentripplanner.routing.graphfinder.PatternAtStop;
import org.opentripplanner.routing.graphfinder.PlaceAtDistance;
import org.opentripplanner.routing.graphfinder.PlaceType;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalPlaceVertex;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.VehicleParkingEntranceVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.service.TransitService;

public class PlaceFinderTraverseVisitor
implements TraverseVisitor<State, Edge> {
    public final List<PlaceAtDistance> placesFound = new ArrayList<PlaceAtDistance>();
    private final TransitService transitService;
    private final Set<TransitMode> filterByModes;
    private final Set<FeedScopedId> filterByStops;
    private final Set<FeedScopedId> filterByRoutes;
    private final Set<String> filterByVehicleRental;
    private final Set<String> seenPatternAtStops = new HashSet<String>();
    private final Set<FeedScopedId> seenStops = new HashSet<FeedScopedId>();
    private final Set<FeedScopedId> seenVehicleRentalPlaces = new HashSet<FeedScopedId>();
    private final Set<FeedScopedId> seenParkingLots = new HashSet<FeedScopedId>();
    private final boolean includeStops;
    private final boolean includePatternAtStops;
    private final boolean includeVehicleRentals;
    private final boolean includeCarParking;
    private final boolean includeBikeParking;
    private final int maxResults;
    private final double radiusMeters;

    public PlaceFinderTraverseVisitor(TransitService transitService, List<TransitMode> filterByModes, List<PlaceType> filterByPlaceTypes, List<FeedScopedId> filterByStops, List<FeedScopedId> filterByRoutes, List<String> filterByBikeRentalStations, int maxResults, double radiusMeters) {
        this.transitService = transitService;
        this.filterByModes = PlaceFinderTraverseVisitor.toSet(filterByModes);
        this.filterByStops = PlaceFinderTraverseVisitor.toSet(filterByStops);
        this.filterByRoutes = PlaceFinderTraverseVisitor.toSet(filterByRoutes);
        this.filterByVehicleRental = PlaceFinderTraverseVisitor.toSet(filterByBikeRentalStations);
        this.includeStops = this.shouldInclude(filterByPlaceTypes, PlaceType.STOP);
        this.includePatternAtStops = this.shouldInclude(filterByPlaceTypes, PlaceType.PATTERN_AT_STOP);
        this.includeVehicleRentals = this.shouldInclude(filterByPlaceTypes, PlaceType.VEHICLE_RENT);
        this.includeCarParking = this.shouldInclude(filterByPlaceTypes, PlaceType.CAR_PARK);
        this.includeBikeParking = this.shouldInclude(filterByPlaceTypes, PlaceType.BIKE_PARK);
        this.maxResults = maxResults;
        this.radiusMeters = radiusMeters;
    }

    @Override
    public void visitEdge(Edge edge) {
    }

    @Override
    public void visitVertex(State state) {
        Vertex vertex = state.getVertex();
        double distance = state.getWalkDistance();
        if (vertex instanceof TransitStopVertex) {
            TransitStopVertex transitVertex = (TransitStopVertex)vertex;
            RegularStop stop = transitVertex.getStop();
            this.handleStop(stop, distance);
            this.handlePatternsAtStop(stop, distance);
        } else if (vertex instanceof VehicleRentalPlaceVertex) {
            VehicleRentalPlaceVertex rentalVertex = (VehicleRentalPlaceVertex)vertex;
            this.handleVehicleRental(rentalVertex.getStation(), distance);
        } else if (vertex instanceof VehicleParkingEntranceVertex) {
            VehicleParkingEntranceVertex parkingVertex = (VehicleParkingEntranceVertex)vertex;
            this.handleParking(parkingVertex.getVehicleParking(), distance);
        }
    }

    @Override
    public void visitEnqueue() {
    }

    public SkipEdgeStrategy<State, Edge> getSkipEdgeStrategy() {
        return (current, edge) -> {
            double furthestDistance = this.radiusMeters;
            if (this.placesFound.size() >= this.maxResults) {
                furthestDistance = 0.0;
                for (PlaceAtDistance pad : this.placesFound) {
                    if (!(pad.distance() > furthestDistance)) continue;
                    furthestDistance = pad.distance();
                }
            }
            return current.getWalkDistance() > furthestDistance;
        };
    }

    private static <T> Set<T> toSet(List<T> list) {
        if (list == null) {
            return null;
        }
        return Set.copyOf(list);
    }

    private void handleParking(VehicleParking parking, double distance) {
        if (!this.seenParkingLots.contains(parking.getId())) {
            if (this.includeBikeParking && parking.hasBicyclePlaces()) {
                this.placesFound.add(new PlaceAtDistance(parking, distance));
                this.seenParkingLots.add(parking.getId());
            }
            if (this.includeCarParking && parking.hasAnyCarPlaces() && !this.seenParkingLots.contains(parking.getId())) {
                this.placesFound.add(new PlaceAtDistance(parking, distance));
                this.seenParkingLots.add(parking.getId());
            }
        }
    }

    private boolean shouldInclude(List<PlaceType> filterByPlaceTypes, PlaceType type) {
        return filterByPlaceTypes == null || filterByPlaceTypes.contains((Object)type);
    }

    private boolean stopHasPatternsWithMode(RegularStop stop, Set<TransitMode> modes) {
        return this.transitService.getPatternsForStop(stop).stream().map(TripPattern::getMode).anyMatch(modes::contains);
    }

    private void handleStop(RegularStop stop, double distance) {
        if (this.filterByStops != null && !this.filterByStops.contains(stop.getId())) {
            return;
        }
        if (this.includeStops && !this.seenStops.contains(stop.getId()) && (this.filterByModes == null || this.stopHasPatternsWithMode(stop, this.filterByModes))) {
            this.placesFound.add(new PlaceAtDistance(stop, distance));
            this.seenStops.add(stop.getId());
        }
    }

    private void handlePatternsAtStop(RegularStop stop, double distance) {
        if (this.includePatternAtStops) {
            List<TripPattern> patterns = this.transitService.getPatternsForStop(stop).stream().filter(pattern -> this.filterByModes == null || this.filterByModes.contains((Object)pattern.getMode())).filter(pattern -> this.filterByRoutes == null || this.filterByRoutes.contains(pattern.getRoute().getId())).filter(pattern -> pattern.canBoard(stop)).toList();
            for (TripPattern pattern2 : patterns) {
                String seenKey = pattern2.getRoute().getId().toString() + ":" + pattern2.getId().toString();
                if (this.seenPatternAtStops.contains(seenKey)) continue;
                PatternAtStop row = new PatternAtStop(stop, pattern2);
                PlaceAtDistance place = new PlaceAtDistance(row, distance);
                this.placesFound.add(place);
                this.seenPatternAtStops.add(seenKey);
            }
        }
    }

    private void handleVehicleRental(VehicleRentalPlace station, double distance) {
        if (!this.includeVehicleRentals) {
            return;
        }
        if (this.filterByVehicleRental != null && !this.filterByVehicleRental.contains(station.getStationId())) {
            return;
        }
        if (this.seenVehicleRentalPlaces.contains(station.getId())) {
            return;
        }
        this.seenVehicleRentalPlaces.add(station.getId());
        this.placesFound.add(new PlaceAtDistance(station, distance));
    }
}

