/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graph.index;

import java.util.stream.Stream;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.HashGridSpatialIndex;
import org.opentripplanner.routing.linking.Scope;
import org.opentripplanner.street.model.edge.Edge;

public class EdgeSpatialIndex {
    private final HashGridSpatialIndex<Edge> permanentEdgeIndex = new HashGridSpatialIndex();
    private final HashGridSpatialIndex<Edge> realTimeEdgeIndex = new HashGridSpatialIndex();

    public void insert(LineString lineString, Object obj, Scope scope) {
        switch (scope) {
            case PERMANENT: {
                this.permanentEdgeIndex.insert(lineString, obj);
                break;
            }
            case REALTIME: {
                this.realTimeEdgeIndex.insert(lineString, obj);
                break;
            }
            case REQUEST: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void remove(Envelope envelope, Object item, Scope scope) {
        switch (scope) {
            case PERMANENT: {
                this.permanentEdgeIndex.remove(envelope, item);
                break;
            }
            case REALTIME: {
                this.realTimeEdgeIndex.remove(envelope, item);
                break;
            }
            case REQUEST: {
                throw new IllegalArgumentException();
            }
        }
    }

    public final Stream<Edge> query(Envelope envelope, Scope scope) {
        return switch (scope) {
            default -> throw new IncompatibleClassChangeError();
            case Scope.PERMANENT, Scope.REALTIME -> this.permanentEdgeIndex.query(envelope).stream();
            case Scope.REQUEST -> Stream.concat(this.permanentEdgeIndex.query(envelope).stream(), this.realTimeEdgeIndex.query(envelope).stream());
        };
    }

    public void compact() {
        this.permanentEdgeIndex.compact();
    }
}

