/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graph;

import com.google.common.annotations.VisibleForTesting;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.ext.dataoverlay.configuration.DataOverlayParameterBindings;
import org.opentripplanner.ext.geocoder.LuceneIndex;
import org.opentripplanner.framework.geometry.CompactElevationProfile;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.model.calendar.openinghours.OpeningHoursCalendarService;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.graph.index.StreetIndex;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.routing.services.notes.StreetNotesService;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingService;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.service.StopModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graph
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Graph.class);
    public final StreetNotesService streetNotesService = new StreetNotesService();
    private final Map<String, Vertex> vertices = new ConcurrentHashMap<String, Vertex>();
    public final transient Deduplicator deduplicator;
    public final Instant buildTime = Instant.now();
    @Nullable
    private final OpeningHoursCalendarService openingHoursCalendarService;
    private transient StreetIndex streetIndex;
    private Geometry convexHull = null;
    public Preferences preferences = null;
    public boolean hasStreets = false;
    public boolean hasLinkedBikeParks = false;
    public Double ellipsoidToGeoidDifference = 0.0;
    public boolean hasElevation = false;
    public Double minElevation = null;
    public Double maxElevation = null;
    private double distanceBetweenElevationSamples;
    private final VehicleParkingService vehicleParkingService = new VehicleParkingService();
    private FareService fareService;
    public long nextSplitNumber = 0L;
    public DataOverlayParameterBindings dataOverlayParameterBindings;
    private LuceneIndex luceneIndex;

    @Inject
    public Graph(Deduplicator deduplicator, @Nullable OpeningHoursCalendarService openingHoursCalendarService) {
        this.deduplicator = deduplicator;
        this.openingHoursCalendarService = openingHoursCalendarService;
    }

    public Graph(Deduplicator deduplicator) {
        this(deduplicator, null);
    }

    public Graph() {
        this(new Deduplicator(), null);
    }

    public void addVertex(Vertex v) {
        Vertex old = this.vertices.put(v.getLabel(), v);
        if (old != null) {
            if (old == v) {
                LOG.error("repeatedly added the same vertex: {}", (Object)v);
            } else {
                LOG.error("duplicate vertex label in graph (added vertex to graph anyway): {}", (Object)v);
            }
        }
    }

    public void removeEdge(Edge e) {
        if (e != null) {
            this.streetNotesService.removeStaticNotes(e);
            e.remove();
        }
    }

    @VisibleForTesting
    public Vertex getVertex(String label) {
        return this.vertices.get(label);
    }

    public Collection<Vertex> getVertices() {
        return this.vertices.values();
    }

    public <T extends Vertex> List<T> getVerticesOfType(Class<T> cls) {
        return this.getVertices().stream().filter(cls::isInstance).map(cls::cast).collect(Collectors.toList());
    }

    public TransitStopVertex getStopVertexForStopId(FeedScopedId id) {
        return this.streetIndex.findTransitStopVertices(id);
    }

    public Collection<Edge> getEdges() {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (Vertex v : this.getVertices()) {
            edges.addAll(v.getOutgoing());
        }
        return edges;
    }

    public <T extends Edge> List<T> getEdgesOfType(Class<T> cls) {
        return this.getEdges().stream().filter(cls::isInstance).map(cls::cast).collect(Collectors.toList());
    }

    public Collection<StreetEdge> getStreetEdges() {
        return this.getEdgesOfType(StreetEdge.class);
    }

    public boolean containsVertex(Vertex v) {
        return v != null && this.vertices.get(v.getLabel()) == v;
    }

    public void remove(Vertex vertex) {
        this.vertices.remove(vertex.getLabel());
    }

    public void removeIfUnconnected(Vertex v) {
        if (v.getDegreeIn() == 0 && v.getDegreeOut() == 0) {
            this.remove(v);
        }
    }

    public Envelope getExtent() {
        Envelope env = new Envelope();
        for (Vertex v : this.getVertices()) {
            env.expandToInclude(v.getCoordinate());
        }
        return env;
    }

    public int countVertices() {
        return this.vertices.size();
    }

    public int countEdges() {
        int ne = 0;
        for (Vertex v : this.getVertices()) {
            ne += v.getDegreeOut();
        }
        return ne;
    }

    public void index(StopModel stopModel) {
        LOG.info("Index street model...");
        this.streetIndex = new StreetIndex(this, stopModel);
        LOG.info("Index street model complete.");
    }

    @Nullable
    public OpeningHoursCalendarService getOpeningHoursCalendarService() {
        return this.openingHoursCalendarService;
    }

    public StreetIndex getStreetIndex() {
        return this.streetIndex;
    }

    public StreetIndex getStreetIndexSafe(StopModel stopModel) {
        this.indexIfNotIndexed(stopModel);
        return this.streetIndex;
    }

    public VertexLinker getLinker() {
        return this.streetIndex.getVertexLinker();
    }

    public VertexLinker getLinkerSafe(StopModel stopModel) {
        this.indexIfNotIndexed(stopModel);
        return this.streetIndex.getVertexLinker();
    }

    public void calculateConvexHull() {
        this.convexHull = GeometryUtils.makeConvexHull(this.getVertices(), Vertex::getCoordinate);
    }

    public Geometry getConvexHull() {
        return this.convexHull;
    }

    public void initEllipsoidToGeoidDifference(double value, double lat, double lon) {
        this.ellipsoidToGeoidDifference = value;
        LOG.info("Computed ellipsoid/geoid offset at ({}, {}) as {}", new Object[]{lat, lon, this.ellipsoidToGeoidDifference});
    }

    public double getDistanceBetweenElevationSamples() {
        return this.distanceBetweenElevationSamples;
    }

    public void setDistanceBetweenElevationSamples(double distanceBetweenElevationSamples) {
        this.distanceBetweenElevationSamples = distanceBetweenElevationSamples;
        CompactElevationProfile.setDistanceBetweenSamplesM(distanceBetweenElevationSamples);
    }

    @Nonnull
    public VehicleParkingService getVehicleParkingService() {
        return this.vehicleParkingService;
    }

    public FareService getFareService() {
        return this.fareService;
    }

    public void setFareService(FareService fareService) {
        this.fareService = fareService;
    }

    public LuceneIndex getLuceneIndex() {
        return this.luceneIndex;
    }

    public void setLuceneIndex(LuceneIndex luceneIndex) {
        this.luceneIndex = luceneIndex;
    }

    private void indexIfNotIndexed(StopModel stopModel) {
        if (this.streetIndex == null) {
            this.index(stopModel);
        }
    }
}

