/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.response;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingResponse;
import org.opentripplanner.routing.api.response.ViaRoutingResponseConnection;

public record ViaRoutingResponse(Map<Itinerary, List<Itinerary>> plan, List<RoutingResponse> routingResponses, List<RoutingError> routingErrors) {
    public List<List<Itinerary>> getItineraries() {
        return this.routingResponses.stream().map(RoutingResponse::getTripPlan).map(plan -> plan.itineraries).toList();
    }

    public List<List<ViaRoutingResponseConnection>> createConnections() {
        ArrayList<List<ViaRoutingResponseConnection>> connectionLists = new ArrayList<List<ViaRoutingResponseConnection>>();
        List<List<Itinerary>> viaJourneys = this.getItineraries();
        for (int i = 0; i < viaJourneys.size() - 1; ++i) {
            ArrayList<ViaRoutingResponseConnection> connectionList = new ArrayList<ViaRoutingResponseConnection>();
            connectionLists.add(connectionList);
            List<Itinerary> itineraries = viaJourneys.get(i);
            List<Itinerary> nextItineraries = viaJourneys.get(i + 1);
            for (int j = 0; j < itineraries.size(); ++j) {
                Itinerary itinerary = itineraries.get(j);
                List<Itinerary> connections = this.plan.get(itinerary);
                if (connections == null) continue;
                for (Itinerary connection : connections) {
                    int index = nextItineraries.indexOf(connection);
                    if (index == -1) continue;
                    connectionList.add(new ViaRoutingResponseConnection(j, index));
                }
            }
        }
        return connectionLists;
    }
}

