/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.request.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.routing.api.request.request.filter.VehicleParkingFilter;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;

public class VehicleParkingFilterRequest {
    private final VehicleParkingFilter[] not;
    private final VehicleParkingFilter[] select;

    public VehicleParkingFilterRequest(Collection<VehicleParkingFilter> not, Collection<VehicleParkingFilter> select) {
        this.not = VehicleParkingFilterRequest.makeFilter(not);
        this.select = VehicleParkingFilterRequest.makeFilter(select);
    }

    public VehicleParkingFilterRequest(VehicleParkingFilter not, VehicleParkingFilter select) {
        this(List.of(not), List.of(select));
    }

    public static VehicleParkingFilterRequest empty() {
        return new VehicleParkingFilterRequest(List.of(), List.of());
    }

    public boolean matches(VehicleParking p) {
        for (VehicleParkingFilter n : this.not) {
            if (!n.matches(p)) continue;
            return false;
        }
        if (this.select.length == 0) {
            return true;
        }
        for (VehicleParkingFilter s : this.select) {
            if (!s.matches(p)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addCol("not", Arrays.asList(this.not)).addCol("select", Arrays.asList(this.select)).toString();
    }

    @Nonnull
    private static VehicleParkingFilter[] makeFilter(Collection<VehicleParkingFilter> select) {
        return (VehicleParkingFilter[])select.stream().filter(f -> !f.isEmpty()).toArray(VehicleParkingFilter[]::new);
    }
}

