/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.request;

import java.io.Serializable;
import org.opentripplanner.routing.api.request.RequestModes;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.api.request.request.TransitRequest;
import org.opentripplanner.routing.api.request.request.VehicleParkingRequest;
import org.opentripplanner.routing.api.request.request.VehicleRentalRequest;

public class JourneyRequest
implements Cloneable,
Serializable {
    private VehicleRentalRequest rental = new VehicleRentalRequest();
    private VehicleParkingRequest parking = new VehicleParkingRequest();
    private TransitRequest transit = new TransitRequest();
    private StreetRequest access = new StreetRequest();
    private StreetRequest egress = new StreetRequest();
    private StreetRequest transfer = new StreetRequest();
    private StreetRequest direct = new StreetRequest();

    public VehicleRentalRequest rental() {
        return this.rental;
    }

    public VehicleParkingRequest parking() {
        return this.parking;
    }

    public TransitRequest transit() {
        return this.transit;
    }

    public StreetRequest access() {
        return this.access;
    }

    public StreetRequest egress() {
        return this.egress;
    }

    public StreetRequest transfer() {
        return this.transfer;
    }

    public StreetRequest direct() {
        return this.direct;
    }

    public void setModes(RequestModes modes) {
        this.transfer().setMode(modes.transferMode);
        this.access().setMode(modes.accessMode);
        this.egress().setMode(modes.egressMode);
        this.direct().setMode(modes.directMode);
    }

    public RequestModes modes() {
        return RequestModes.of().withAccessMode(this.access.mode()).withTransferMode(this.transfer.mode()).withEgressMode(this.egress.mode()).withDirectMode(this.direct.mode()).build();
    }

    public JourneyRequest clone() {
        try {
            JourneyRequest clone = (JourneyRequest)super.clone();
            clone.rental = this.rental.clone();
            clone.parking = this.parking.clone();
            clone.transit = this.transit.clone();
            clone.access = this.access.clone();
            clone.egress = this.egress.clone();
            clone.transfer = this.transfer.clone();
            clone.direct = this.direct.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

