/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.raptor.api.model.SearchDirection;
import org.opentripplanner.raptor.api.request.Optimization;
import org.opentripplanner.raptor.api.request.RaptorProfile;
import org.opentripplanner.routing.api.request.framework.Units;

public final class RaptorPreferences
implements Serializable {
    public static final RaptorPreferences DEFAULT = new RaptorPreferences();
    private static final double MIN_RELAX_COST_AT_DESTINATION = 1.0;
    private static final double MAX_RELAX_COST_AT_DESTINATION = 2.0;
    private final Set<Optimization> optimizations;
    private final RaptorProfile profile;
    private final SearchDirection searchDirection;
    private final Instant timeLimit;
    private final Double relaxGeneralizedCostAtDestination;

    private RaptorPreferences() {
        this.optimizations = EnumSet.of(Optimization.PARETO_CHECK_AGAINST_DESTINATION);
        this.profile = RaptorProfile.MULTI_CRITERIA;
        this.searchDirection = SearchDirection.FORWARD;
        this.timeLimit = null;
        this.relaxGeneralizedCostAtDestination = null;
    }

    private RaptorPreferences(Builder builder) {
        this.optimizations = Collections.unmodifiableSet(builder.copyOptimizations());
        this.profile = Objects.requireNonNull(builder.profile);
        this.searchDirection = Objects.requireNonNull(builder.searchDirection);
        this.timeLimit = builder.timeLimit;
        this.relaxGeneralizedCostAtDestination = Units.normalizedOptionalFactor(builder.relaxGeneralizedCostAtDestination, 1.0, 2.0);
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public Set<Optimization> optimizations() {
        return this.optimizations;
    }

    public RaptorProfile profile() {
        return this.profile;
    }

    public SearchDirection searchDirection() {
        return this.searchDirection;
    }

    @Nullable
    public Instant timeLimit() {
        return this.timeLimit;
    }

    public Optional<Double> relaxGeneralizedCostAtDestination() {
        return Optional.ofNullable(this.relaxGeneralizedCostAtDestination);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RaptorPreferences that = (RaptorPreferences)o;
        return this.optimizations.equals(that.optimizations) && this.profile == that.profile && this.searchDirection == that.searchDirection && Objects.equals(this.timeLimit, that.timeLimit) && Objects.equals(this.relaxGeneralizedCostAtDestination, that.relaxGeneralizedCostAtDestination);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.optimizations, this.profile, this.searchDirection, this.timeLimit, this.relaxGeneralizedCostAtDestination});
    }

    public String toString() {
        return ToStringBuilder.of(RaptorPreferences.class).addCol("optimizations", this.optimizations, RaptorPreferences.DEFAULT.optimizations).addEnum("profile", this.profile, RaptorPreferences.DEFAULT.profile).addEnum("searchDirection", this.searchDirection, RaptorPreferences.DEFAULT.searchDirection).addDateTime("timeLimit", this.timeLimit).addNum("relaxGeneralizedCostAtDestination", (Number)this.relaxGeneralizedCostAtDestination, RaptorPreferences.DEFAULT.relaxGeneralizedCostAtDestination).toString();
    }

    public static class Builder {
        private final RaptorPreferences original;
        private RaptorProfile profile;
        private SearchDirection searchDirection;
        private Set<Optimization> optimizations;
        private Instant timeLimit;
        private Double relaxGeneralizedCostAtDestination;

        public Builder(RaptorPreferences original) {
            this.original = original;
            this.profile = original.profile;
            this.searchDirection = original.searchDirection;
            this.optimizations = null;
            this.timeLimit = original.timeLimit;
            this.relaxGeneralizedCostAtDestination = original.relaxGeneralizedCostAtDestination;
        }

        public Builder withOptimizations(Collection<Optimization> optimizations) {
            this.optimizations = optimizations.isEmpty() ? EnumSet.noneOf(Optimization.class) : EnumSet.copyOf(optimizations);
            return this;
        }

        public Builder withProfile(RaptorProfile profile) {
            this.profile = profile;
            return this;
        }

        public Builder withSearchDirection(SearchDirection searchDirection) {
            this.searchDirection = searchDirection;
            return this;
        }

        public Builder withTimeLimit(Instant timeLimit) {
            this.timeLimit = timeLimit;
            return this;
        }

        public Builder withRelaxGeneralizedCostAtDestination(@Nullable Double relaxGeneralizedCostAtDestination) {
            this.relaxGeneralizedCostAtDestination = relaxGeneralizedCostAtDestination;
            return this;
        }

        public RaptorPreferences build() {
            RaptorPreferences value = new RaptorPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        private Set<Optimization> copyOptimizations() {
            return this.optimizations == null ? this.original.optimizations : this.optimizations;
        }
    }
}

