/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.framework.lang.DoubleUtils;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.routing.api.request.framework.Units;

public final class CarPreferences
implements Serializable {
    public static final CarPreferences DEFAULT = new CarPreferences();
    private final double speed;
    private final double reluctance;
    private final int parkTime;
    private final int parkCost;
    private final int pickupTime;
    private final int pickupCost;
    private final int dropoffTime;
    private final double accelerationSpeed;
    private final double decelerationSpeed;

    private CarPreferences() {
        this.speed = 40.0;
        this.reluctance = 2.0;
        this.parkTime = 60;
        this.parkCost = 120;
        this.pickupTime = 60;
        this.pickupCost = 120;
        this.dropoffTime = 120;
        this.accelerationSpeed = 2.9;
        this.decelerationSpeed = 2.9;
    }

    private CarPreferences(Builder builder) {
        this.speed = Units.speed(builder.speed);
        this.reluctance = Units.reluctance(builder.reluctance);
        this.parkTime = Units.duration(builder.parkTime);
        this.parkCost = Units.cost(builder.parkCost);
        this.pickupTime = Units.duration(builder.pickupTime);
        this.pickupCost = Units.cost(builder.pickupCost);
        this.dropoffTime = Units.duration(builder.dropoffTime);
        this.accelerationSpeed = Units.acceleration(builder.accelerationSpeed);
        this.decelerationSpeed = Units.acceleration(builder.decelerationSpeed);
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public double speed() {
        return this.speed;
    }

    public double reluctance() {
        return this.reluctance;
    }

    public int parkTime() {
        return this.parkTime;
    }

    public int parkCost() {
        return this.parkCost;
    }

    public int pickupTime() {
        return this.pickupTime;
    }

    public int pickupCost() {
        return this.pickupCost;
    }

    public int dropoffTime() {
        return this.dropoffTime;
    }

    public double accelerationSpeed() {
        return this.accelerationSpeed;
    }

    public double decelerationSpeed() {
        return this.decelerationSpeed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CarPreferences that = (CarPreferences)o;
        return DoubleUtils.doubleEquals(that.speed, this.speed) && DoubleUtils.doubleEquals(that.reluctance, this.reluctance) && this.parkTime == that.parkTime && this.parkCost == that.parkCost && this.pickupTime == that.pickupTime && this.pickupCost == that.pickupCost && this.dropoffTime == that.dropoffTime && DoubleUtils.doubleEquals(that.accelerationSpeed, this.accelerationSpeed) && DoubleUtils.doubleEquals(that.decelerationSpeed, this.decelerationSpeed);
    }

    public int hashCode() {
        return Objects.hash(this.speed, this.reluctance, this.parkTime, this.parkCost, this.pickupTime, this.pickupCost, this.dropoffTime, this.accelerationSpeed, this.decelerationSpeed);
    }

    public String toString() {
        return ToStringBuilder.of(CarPreferences.class).addNum("speed", (Number)this.speed, CarPreferences.DEFAULT.speed).addNum("reluctance", (Number)this.reluctance, CarPreferences.DEFAULT.reluctance).addNum("parkTime", (Number)this.parkTime, CarPreferences.DEFAULT.parkTime).addNum("parkCost", (Number)this.parkCost, CarPreferences.DEFAULT.parkCost).addNum("pickupTime", (Number)this.pickupTime, CarPreferences.DEFAULT.pickupTime).addNum("pickupCost", (Number)this.pickupCost, CarPreferences.DEFAULT.pickupCost).addNum("dropoffTime", (Number)this.dropoffTime, CarPreferences.DEFAULT.dropoffTime).addNum("accelerationSpeed", (Number)this.accelerationSpeed, CarPreferences.DEFAULT.accelerationSpeed).addNum("decelerationSpeed", (Number)this.decelerationSpeed, CarPreferences.DEFAULT.decelerationSpeed).toString();
    }

    public static class Builder {
        private final CarPreferences original;
        private double speed;
        private double reluctance;
        private int parkTime;
        private int parkCost;
        private int pickupTime;
        private int pickupCost;
        private int dropoffTime;
        private double accelerationSpeed;
        private double decelerationSpeed;

        public Builder(CarPreferences original) {
            this.original = original;
            this.speed = original.speed;
            this.reluctance = original.reluctance;
            this.parkTime = original.parkTime;
            this.parkCost = original.parkCost;
            this.pickupTime = original.pickupTime;
            this.pickupCost = original.pickupCost;
            this.dropoffTime = original.dropoffTime;
            this.accelerationSpeed = original.accelerationSpeed;
            this.decelerationSpeed = original.decelerationSpeed;
        }

        public CarPreferences original() {
            return this.original;
        }

        public Builder withSpeed(double speed) {
            this.speed = speed;
            return this;
        }

        public Builder withReluctance(double reluctance) {
            this.reluctance = reluctance;
            return this;
        }

        public Builder withParkTime(int parkTime) {
            this.parkTime = parkTime;
            return this;
        }

        public Builder withParkCost(int parkCost) {
            this.parkCost = parkCost;
            return this;
        }

        public Builder withPickupTime(int pickupTime) {
            this.pickupTime = pickupTime;
            return this;
        }

        public Builder withPickupCost(int pickupCost) {
            this.pickupCost = pickupCost;
            return this;
        }

        public Builder withDropoffTime(int dropoffTime) {
            this.dropoffTime = dropoffTime;
            return this;
        }

        public Builder withAccelerationSpeed(double accelerationSpeed) {
            this.accelerationSpeed = accelerationSpeed;
            return this;
        }

        public Builder withDecelerationSpeed(double decelerationSpeed) {
            this.decelerationSpeed = decelerationSpeed;
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public CarPreferences build() {
            CarPreferences value = new CarPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

