/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.routing.api.request.framework.Units;

public final class AccessibilityPreferences {
    private static final int NOT_SET = 9999999;
    private static final AccessibilityPreferences ONLY_CONSIDER_ACCESSIBLE = new AccessibilityPreferences(true, 9999999, 9999999);
    private final boolean onlyConsiderAccessible;
    private final int unknownCost;
    private final int inaccessibleCost;
    private static final AccessibilityPreferences DEFAULT_UNSET = AccessibilityPreferences.ofCost(9999999, 9999999);

    private AccessibilityPreferences(boolean onlyConsiderAccessible, int unknownCost, int inaccessibleCost) {
        this.onlyConsiderAccessible = onlyConsiderAccessible;
        this.unknownCost = Units.cost(unknownCost);
        this.inaccessibleCost = Units.cost(inaccessibleCost);
    }

    public static AccessibilityPreferences ofOnlyAccessible() {
        return ONLY_CONSIDER_ACCESSIBLE;
    }

    public static AccessibilityPreferences ofCost(int unknownCost, int inaccessibleCost) {
        return new AccessibilityPreferences(false, unknownCost, inaccessibleCost);
    }

    public static Builder of() {
        return DEFAULT_UNSET.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this, this);
    }

    public Builder copyOfWithDefaultCosts(AccessibilityPreferences defaultCosts) {
        return new Builder(this, defaultCosts);
    }

    public boolean onlyConsiderAccessible() {
        return this.onlyConsiderAccessible;
    }

    public int unknownCost() {
        return this.unknownCost;
    }

    public int inaccessibleCost() {
        return this.inaccessibleCost;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessibilityPreferences that = (AccessibilityPreferences)o;
        return this.onlyConsiderAccessible == that.onlyConsiderAccessible && this.unknownCost == that.unknownCost && this.inaccessibleCost == that.inaccessibleCost;
    }

    public int hashCode() {
        return Objects.hash(this.onlyConsiderAccessible, this.unknownCost, this.inaccessibleCost);
    }

    public String toString() {
        return this.toString(DEFAULT_UNSET);
    }

    public String toString(AccessibilityPreferences defaultCosts) {
        if (this.onlyConsiderAccessible) {
            return "OnlyConsiderAccessible";
        }
        return ToStringBuilder.of(AccessibilityPreferences.class).addCost("unknownCost", this.unknownCost, defaultCosts.unknownCost).addCost("inaccessibleCost", this.inaccessibleCost, defaultCosts.inaccessibleCost).toString();
    }

    public static class Builder {
        private final AccessibilityPreferences original;
        private boolean onlyConsiderAccessible;
        private int unknownCost;
        private int inaccessibleCost;

        private Builder(AccessibilityPreferences original, AccessibilityPreferences defaultCosts) {
            this.original = original;
            if (original.onlyConsiderAccessible) {
                this.onlyConsiderAccessible = true;
                this.unknownCost = defaultCosts.unknownCost;
                this.inaccessibleCost = defaultCosts.inaccessibleCost;
            } else {
                this.onlyConsiderAccessible = false;
                this.unknownCost = original.unknownCost;
                this.inaccessibleCost = original.inaccessibleCost;
            }
        }

        public boolean onlyConsiderAccessible() {
            return this.onlyConsiderAccessible;
        }

        public Builder withAccessibleOnly() {
            this.onlyConsiderAccessible = true;
            return this;
        }

        public int unknownCost() {
            return this.unknownCost;
        }

        public Builder withUnknownCost(int unknownCost) {
            this.onlyConsiderAccessible = false;
            this.unknownCost = unknownCost;
            return this;
        }

        public int inaccessibleCost() {
            return this.inaccessibleCost;
        }

        public Builder withInaccessibleCost(int inaccessibleCost) {
            this.onlyConsiderAccessible = false;
            this.inaccessibleCost = inaccessibleCost;
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public AccessibilityPreferences build() {
            AccessibilityPreferences value = this.onlyConsiderAccessible ? AccessibilityPreferences.ofOnlyAccessible() : AccessibilityPreferences.ofCost(this.unknownCost, this.inaccessibleCost);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

