/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.framework;

import org.opentripplanner.framework.lang.DoubleUtils;

public class Units {
    private static final double ONE_MACH = 340.0;

    private Units() {
    }

    public static int cost(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Negative generalized-cost not expected: " + value);
        }
        return value;
    }

    public static double reluctance(double value) {
        return Units.normalizedFactor(value, 0.0, Double.MAX_VALUE);
    }

    public static double normalizedFactor(double value, double minValue, double maxValue) {
        if (value < minValue) {
            throw new IllegalArgumentException("Min limit(" + minValue + ") exceeded: " + value);
        }
        if (value > maxValue) {
            throw new IllegalArgumentException("Max limit(" + maxValue + ") exceeded: " + value);
        }
        if (Math.abs(value) < 2.0) {
            return DoubleUtils.roundTo2Decimals(value);
        }
        if (Math.abs(value) < 10.0) {
            return DoubleUtils.roundTo1Decimal(value);
        }
        return DoubleUtils.roundToZeroDecimals(value);
    }

    public static Double normalizedOptionalFactor(Double value, double minValue, double maxValue) {
        return value == null ? null : Double.valueOf(Units.normalizedFactor(value, minValue, maxValue));
    }

    public static int duration(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Negative slack/time/duration not expected: " + seconds);
        }
        return seconds;
    }

    public static double speed(double metersPerSecond) {
        if (metersPerSecond < 0.0) {
            throw new IllegalArgumentException("Negative speed not expected: " + metersPerSecond + " m/s");
        }
        if (metersPerSecond < 0.1) {
            return 0.1;
        }
        if (metersPerSecond < 2.0) {
            return DoubleUtils.roundTo2Decimals(metersPerSecond);
        }
        if (metersPerSecond < 10.0) {
            return DoubleUtils.roundTo1Decimal(metersPerSecond);
        }
        if (metersPerSecond > 340.0) {
            throw new IllegalArgumentException("Are you flying in supersonic speed: " + metersPerSecond + " m/s");
        }
        return DoubleUtils.roundToZeroDecimals(metersPerSecond);
    }

    public static double acceleration(double metersPerSecondSquared) {
        if (metersPerSecondSquared < 0.0) {
            throw new IllegalArgumentException("Negative acceleration or deceleration not expected: " + metersPerSecondSquared);
        }
        if (metersPerSecondSquared < 0.1) {
            return 0.1;
        }
        return DoubleUtils.roundTo1Decimal(metersPerSecondSquared);
    }

    public static double ratio(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Ratio between 0.0 and 1.0 expected. Value: " + value);
        }
        return DoubleUtils.roundTo3Decimals(value);
    }

    public static int count(int value, int maxValue) {
        if (value < 0) {
            throw new IllegalArgumentException("Negative count not expected: " + value);
        }
        if (value > maxValue) {
            throw new IllegalArgumentException("Max limit(" + maxValue + ") exceeded: " + value);
        }
        return value;
    }
}

