/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.function.Consumer;
import org.opentripplanner.framework.time.DateUtils;
import org.opentripplanner.framework.time.DurationUtils;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.model.plan.pagecursor.PageCursor;
import org.opentripplanner.model.plan.pagecursor.PageType;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.api.request.request.JourneyRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteRequest
implements Cloneable,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(RouteRequest.class);
    private static final long NOW_THRESHOLD_SEC = DurationUtils.durationInSeconds("15h");
    private GenericLocation from;
    private GenericLocation to;
    private Instant dateTime = Instant.now();
    private Duration searchWindow;
    private PageCursor pageCursor;
    private boolean timetableView = true;
    private boolean arriveBy = false;
    private int numItineraries = 50;
    private Locale locale = new Locale("en", "US");
    private RoutingPreferences preferences = new RoutingPreferences();
    private JourneyRequest journey = new JourneyRequest();
    private boolean wheelchair = false;

    public RouteRequest() {
        this.from = new GenericLocation(null, null);
        this.to = new GenericLocation(null, null);
    }

    public void setJourney(JourneyRequest journey) {
        this.journey = journey;
    }

    public void setArriveBy(boolean arriveBy) {
        this.arriveBy = arriveBy;
    }

    public JourneyRequest journey() {
        return this.journey;
    }

    public RoutingPreferences preferences() {
        return this.preferences;
    }

    public void withPreferences(Consumer<RoutingPreferences.Builder> body) {
        this.preferences = this.preferences.copyOf().apply(body).build();
    }

    void setPreferences(RoutingPreferences preferences) {
        this.preferences = preferences;
    }

    public boolean wheelchair() {
        return this.wheelchair;
    }

    public void setWheelchair(boolean wheelchair) {
        this.wheelchair = wheelchair;
    }

    public Instant dateTime() {
        return this.dateTime;
    }

    public void setDateTime(Instant dateTime) {
        this.dateTime = dateTime;
    }

    public void setDateTime(String date, String time, ZoneId tz) {
        ZonedDateTime dateObject = DateUtils.toZonedDateTime(date, time, tz);
        this.setDateTime(dateObject == null ? Instant.now() : dateObject.toInstant());
    }

    public boolean isTripPlannedForNow() {
        return Duration.between(this.dateTime, Instant.now()).abs().toSeconds() < NOW_THRESHOLD_SEC;
    }

    public SortOrder itinerariesSortOrder() {
        if (this.pageCursor != null) {
            return this.pageCursor.originalSortOrder;
        }
        return this.arriveBy ? SortOrder.STREET_AND_DEPARTURE_TIME : SortOrder.STREET_AND_ARRIVAL_TIME;
    }

    public void applyPageCursor() {
        if (this.pageCursor != null) {
            if (this.pageCursor.latestArrivalTime == null) {
                this.arriveBy = false;
            }
            this.dateTime = this.arriveBy ? this.pageCursor.latestArrivalTime : this.pageCursor.earliestDepartureTime;
            this.journey.setModes(this.journey.modes().copyOf().withDirectMode(StreetMode.NOT_SET).build());
            LOG.debug("Request dateTime={} set from pageCursor.", (Object)this.dateTime);
        }
    }

    public boolean maxNumberOfItinerariesCropHead() {
        if (this.pageCursor == null) {
            return false;
        }
        boolean previousPage = this.pageCursor.type == PageType.PREVIOUS_PAGE;
        return this.pageCursor.originalSortOrder.isSortedByArrivalTimeAcceding() == previousPage;
    }

    public boolean doCropSearchWindowAtTail() {
        if (this.pageCursor == null) {
            return this.itinerariesSortOrder().isSortedByArrivalTimeAcceding();
        }
        return this.pageCursor.type == PageType.NEXT_PAGE;
    }

    public String toString(String sep) {
        return this.from + sep + this.to + sep + this.dateTime + sep + this.arriveBy + sep + this.journey.modes() + this.journey.transit().filters();
    }

    public RouteRequest copyWithDateTimeNow() {
        RouteRequest copy = this.clone();
        copy.setDateTime(Instant.now());
        return copy;
    }

    public RouteRequest clone() {
        try {
            RouteRequest clone = (RouteRequest)super.clone();
            clone.journey = this.journey.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.toString(" ");
    }

    public GenericLocation from() {
        return this.from;
    }

    public void setFrom(GenericLocation from) {
        this.from = from;
    }

    public GenericLocation to() {
        return this.to;
    }

    public void setTo(GenericLocation to) {
        this.to = to;
    }

    public Duration searchWindow() {
        return this.searchWindow;
    }

    public void setSearchWindow(Duration searchWindow) {
        this.searchWindow = searchWindow;
    }

    public Locale locale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public PageCursor pageCursor() {
        return this.pageCursor;
    }

    public void setPageCursorFromEncoded(String pageCursor) {
        this.pageCursor = PageCursor.decode(pageCursor);
    }

    public boolean timetableView() {
        return this.timetableView;
    }

    public void setTimetableView(boolean timetableView) {
        this.timetableView = timetableView;
    }

    public boolean arriveBy() {
        return this.arriveBy;
    }

    public int numItineraries() {
        return this.numItineraries;
    }

    public void setNumItineraries(int numItineraries) {
        this.numItineraries = numItineraries;
    }
}

