/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.alternativelegs;

import gnu.trove.set.TIntSet;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.opentripplanner.framework.time.ServiceDateUtils;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.routing.alternativelegs.AlternativeLegsFilter;
import org.opentripplanner.routing.stoptimes.StopTimesHelper;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitService;

public class AlternativeLegs {
    public static final int ZERO_COST = 0;

    public static List<ScheduledTransitLeg> getAlternativeLegs(Leg leg, Integer numberLegs, TransitService transitService, boolean searchBackward, AlternativeLegsFilter filter) {
        return AlternativeLegs.getAlternativeLegs(leg, numberLegs, transitService, searchBackward, filter, false, false);
    }

    public static List<ScheduledTransitLeg> getAlternativeLegs(Leg leg, Integer numberLegs, TransitService transitService, boolean includeDepartBefore, AlternativeLegsFilter filter, boolean exactOriginStop, boolean exactDestinationStop) {
        StopLocation fromStop = leg.getFrom().stop;
        StopLocation toStop = leg.getTo().stop;
        Station fromStation = fromStop.getParentStation();
        Station toStation = toStop.getParentStation();
        Collection<StopLocation> origins = fromStation == null || exactOriginStop ? List.of(fromStop) : fromStation.getChildStops();
        Collection<StopLocation> destinations = toStation == null || exactDestinationStop ? List.of(toStop) : toStation.getChildStops();
        Comparator<ScheduledTransitLeg> legComparator = Comparator.comparing(ScheduledTransitLeg::getStartTime);
        if (includeDepartBefore) {
            legComparator = legComparator.reversed();
        }
        Predicate<TripPattern> tripPatternPredicate = filter.getFilter(leg);
        return origins.stream().flatMap(stop -> transitService.getPatternsForStop((StopLocation)stop, true).stream()).filter(tripPattern -> tripPattern.getStops().stream().anyMatch(destinations::contains)).filter(tripPatternPredicate).distinct().flatMap(tripPattern -> AlternativeLegs.withBoardingAlightingPositions(origins, destinations, tripPattern)).flatMap(t -> AlternativeLegs.generateLegs(transitService, t, leg.getStartTime(), leg.getServiceDate(), includeDepartBefore)).filter(Predicate.not(leg::isPartiallySameTransitLeg)).sorted(legComparator).limit(numberLegs.intValue()).collect(Collectors.toList());
    }

    @Nonnull
    private static Stream<ScheduledTransitLeg> generateLegs(TransitService transitService, TripPatternBetweenStops tripPatternBetweenStops, ZonedDateTime departureTime, LocalDate originalDate, boolean includeDepartBefore) {
        TripPattern pattern = tripPatternBetweenStops.tripPattern;
        int boardingPosition = tripPatternBetweenStops.positions.boardingPosition;
        int alightingPosition = tripPatternBetweenStops.positions.alightingPosition;
        ZoneId timeZone = transitService.getTimeZone();
        Comparator<TripTimeOnDate> comparator = Comparator.comparing(tts -> tts.getServiceDayMidnight() + (long)tts.getRealtimeDeparture());
        if (includeDepartBefore) {
            comparator = comparator.reversed();
        }
        PriorityQueue<TripTimeOnDate> pq = new PriorityQueue<TripTimeOnDate>(comparator);
        List<LocalDate> serviceDates = List.of(originalDate.minusDays(1L), originalDate, originalDate.plusDays(1L));
        for (LocalDate serviceDate : serviceDates) {
            Timetable timetable = transitService.getTimetableForTripPattern(pattern, serviceDate);
            ZonedDateTime midnight = ServiceDateUtils.asStartOfService(serviceDate, transitService.getTimeZone());
            int secondsSinceMidnight = ServiceDateUtils.secondsSinceStartOfService(midnight, departureTime);
            TIntSet servicesRunning = transitService.getServiceCodesRunningForDate(serviceDate);
            for (TripTimes tripTimes : timetable.getTripTimes()) {
                if (!servicesRunning.contains(tripTimes.getServiceCode()) || StopTimesHelper.skipByTripCancellation(tripTimes, false)) continue;
                boolean bl = includeDepartBefore ? tripTimes.getDepartureTime(boardingPosition) <= secondsSinceMidnight : tripTimes.getDepartureTime(boardingPosition) >= secondsSinceMidnight;
                boolean departureTimeInRange = bl;
                if (!departureTimeInRange) continue;
                pq.add(new TripTimeOnDate(tripTimes, boardingPosition, pattern, serviceDate, midnight.toInstant()));
            }
        }
        ArrayList<ScheduledTransitLeg> res = new ArrayList<ScheduledTransitLeg>();
        while (!pq.isEmpty()) {
            TripTimeOnDate tripTimeOnDate = (TripTimeOnDate)pq.poll();
            res.add(AlternativeLegs.mapToLeg(timeZone, pattern, boardingPosition, alightingPosition, tripTimeOnDate));
        }
        return res.stream();
    }

    @Nonnull
    private static ScheduledTransitLeg mapToLeg(ZoneId timeZone, TripPattern pattern, int boardingPosition, int alightingPosition, TripTimeOnDate tripTimeOnDate) {
        LocalDate serviceDay = tripTimeOnDate.getServiceDay();
        TripTimes tripTimes = tripTimeOnDate.getTripTimes();
        ZonedDateTime boardingTime = ServiceDateUtils.toZonedDateTime(serviceDay, timeZone, tripTimeOnDate.getRealtimeDeparture());
        ZonedDateTime alightingTime = ServiceDateUtils.toZonedDateTime(serviceDay, timeZone, tripTimes.getArrivalTime(alightingPosition));
        return new ScheduledTransitLeg(tripTimes, pattern, boardingPosition, alightingPosition, boardingTime, alightingTime, serviceDay, timeZone, null, null, 0, null);
    }

    @Nonnull
    private static Stream<TripPatternBetweenStops> withBoardingAlightingPositions(Collection<StopLocation> origins, Collection<StopLocation> destinations, TripPattern tripPattern) {
        List<StopLocation> stops = tripPattern.getStops();
        int[] alightingPositions = IntStream.iterate(stops.size() - 1, i -> i - 1).limit(stops.size()).filter(i -> destinations.contains(stops.get(i)) && tripPattern.canAlight(i)).toArray();
        return IntStream.range(0, stops.size()).filter(i -> origins.contains(stops.get(i)) && tripPattern.canBoard(i)).boxed().flatMap(boardingPosition -> Arrays.stream(alightingPositions).filter(alightingPosition -> boardingPosition < alightingPosition).min().stream().mapToObj(alightingPosition -> new BoardingAlightingPositions((int)boardingPosition, alightingPosition))).collect(Collectors.groupingBy(pair -> pair.alightingPosition)).values().stream().flatMap(legGroup -> legGroup.stream().min(Comparator.comparing(ba -> ba.alightingPosition - ba.boardingPosition)).stream()).map(pair -> new TripPatternBetweenStops(tripPattern, (BoardingAlightingPositions)pair));
    }

    private record TripPatternBetweenStops(TripPattern tripPattern, BoardingAlightingPositions positions) {
    }

    private record BoardingAlightingPositions(int boardingPosition, int alightingPosition) {
    }
}

