/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.via;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.RouteViaRequest;
import org.opentripplanner.routing.api.request.ViaLocation;
import org.opentripplanner.routing.api.response.InputField;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingErrorCode;
import org.opentripplanner.routing.api.response.RoutingResponse;
import org.opentripplanner.routing.api.response.ViaRoutingResponse;
import org.opentripplanner.routing.error.RoutingValidationException;

public class ViaRoutingWorker {
    private final RouteViaRequest viaRequest;
    private final RouteRequest request;
    private final Function<RouteRequest, RoutingResponse> routingWorker;
    private static final int MAX_NUMBER_OF_ITINERARIES = 200;

    public ViaRoutingWorker(RouteViaRequest request, Function<RouteRequest, RoutingResponse> routingWorker) {
        this.request = request.routeRequest().clone();
        this.viaRequest = request;
        this.routingWorker = routingWorker;
    }

    public ViaRoutingResponse route() {
        List<RoutingResponse> result = this.viaRequest.viaSegment().stream().map(v -> this.getRoutingResponse(this.viaRequest, (RouteViaRequest.ViaSegment)v)).toList();
        return this.combineRoutingResponse(result);
    }

    private RoutingResponse getRoutingResponse(RouteViaRequest request, RouteViaRequest.ViaSegment v) {
        if (v.viaLocation() != null) {
            this.request.setTo(v.viaLocation().point());
        } else {
            this.request.setTo(request.routeRequest().to());
        }
        this.request.setJourney(v.journeyRequest());
        RoutingResponse response = this.routingWorker.apply(this.request);
        if (v.viaLocation() == null) {
            return response;
        }
        ZonedDateTime firstArrival = this.firstArrival(response).orElseThrow(this::createRoutingException);
        ZonedDateTime lastArrival = this.lastArrival(response).orElseThrow(this::createRoutingException);
        Duration maxSlack = v.viaLocation().maxSlack();
        Duration searchWindow = Duration.between(firstArrival, lastArrival).plus(maxSlack);
        this.request.setNumItineraries(200);
        this.request.setSearchWindow(searchWindow);
        this.request.setDateTime(firstArrival.plus(v.viaLocation().minSlack()).toInstant());
        this.request.setFrom(v.viaLocation().point());
        return response;
    }

    private ViaRoutingResponse combineRoutingResponse(List<RoutingResponse> routingResponses) {
        HashMap<Itinerary, List<Itinerary>> res = new HashMap<Itinerary, List<Itinerary>>();
        ArrayList<RoutingError> routingErrors = new ArrayList<RoutingError>();
        for (int i = 0; i < routingResponses.size() - 1; ++i) {
            List<RoutingError> errors = routingResponses.get(i).getRoutingErrors();
            if (errors != null) {
                routingErrors.addAll(errors);
            }
            for (Itinerary itinerary : routingResponses.get((int)i).getTripPlan().itineraries) {
                List<Itinerary> filteredTransits = this.filterTransits(itinerary, routingResponses.get((int)(i + 1)).getTripPlan().itineraries, this.viaRequest.viaSegment().get(i).viaLocation());
                if (filteredTransits.isEmpty()) continue;
                res.put(itinerary, filteredTransits);
            }
        }
        return new ViaRoutingResponse(res, routingResponses, routingErrors);
    }

    private List<Itinerary> filterTransits(Itinerary i, List<Itinerary> itineraries, ViaLocation viaLocation) {
        return itineraries.stream().filter(this.withinSlackTest(i, viaLocation)).toList();
    }

    private Predicate<Itinerary> withinSlackTest(Itinerary i, ViaLocation v) {
        ZonedDateTime earliestDeparturetime = i.endTime().plus(v.minSlack());
        ZonedDateTime latestDeparturetime = i.endTime().plus(v.maxSlack());
        return j -> !j.startTime().isBefore(earliestDeparturetime) && !j.startTime().isAfter(latestDeparturetime);
    }

    private Optional<ZonedDateTime> firstArrival(RoutingResponse response) {
        return Optional.ofNullable(response.getTripPlan()).map(t -> t.itineraries).flatMap(i -> i.stream().min(Comparator.comparing(Itinerary::endTime))).map(Itinerary::endTime);
    }

    private Optional<ZonedDateTime> lastArrival(RoutingResponse response) {
        return Optional.ofNullable(response.getTripPlan()).map(t -> t.itineraries).flatMap(i -> i.stream().max(Comparator.comparing(Itinerary::endTime))).map(Itinerary::endTime);
    }

    private RoutingValidationException createRoutingException() {
        return new RoutingValidationException(List.of(new RoutingError(RoutingErrorCode.NO_TRANSIT_CONNECTION_IN_SEARCH_WINDOW, InputField.INTERMEDIATE_PLACE)));
    }
}

