/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.services;

import java.util.HashSet;
import java.util.Set;
import org.opentripplanner.framework.time.TimeUtils;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.routing.algorithm.transferoptimization.model.MinCostFilterChain;
import org.opentripplanner.routing.algorithm.transferoptimization.model.OptimizedPathTail;

class TransitPathLegSelector<T extends RaptorTripSchedule> {
    private final MinCostFilterChain<OptimizedPathTail<T>> filter;
    private Set<OptimizedPathTail<T>> remindingLegs;
    private Set<OptimizedPathTail<T>> selectedLegs;
    private int lastLimit = Integer.MAX_VALUE;

    TransitPathLegSelector(MinCostFilterChain<OptimizedPathTail<T>> filter, Set<OptimizedPathTail<T>> legs) {
        this.filter = filter;
        this.remindingLegs = Set.copyOf(legs);
        this.selectedLegs = new HashSet<OptimizedPathTail<T>>();
    }

    Set<OptimizedPathTail<T>> next(int earliestBoardingTime) {
        if (earliestBoardingTime > this.lastLimit) {
            throw new IllegalStateException("The next method must be called with decreasing time limits. minTimeLimit=" + TimeUtils.timeToStrLong(earliestBoardingTime) + ", lastLimit=" + TimeUtils.timeToStrLong(this.lastLimit));
        }
        this.lastLimit = earliestBoardingTime;
        HashSet<OptimizedPathTail<T>> candidates = new HashSet<OptimizedPathTail<T>>();
        HashSet<OptimizedPathTail<T>> rest = new HashSet<OptimizedPathTail<T>>();
        for (OptimizedPathTail<T> it : this.remindingLegs) {
            if (earliestBoardingTime < it.latestPossibleBoardingTime()) {
                candidates.add(it);
                continue;
            }
            rest.add(it);
        }
        if (candidates.isEmpty()) {
            return this.selectedLegs;
        }
        candidates.addAll(this.selectedLegs);
        this.remindingLegs = rest;
        this.selectedLegs = this.filter.filter(candidates);
        return this.selectedLegs;
    }
}

