/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.services;

import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.transferoptimization.model.TripStopTime;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;

public class TransferServiceAdaptor<T extends RaptorTripSchedule> {
    private final IntFunction<StopLocation> stopLookup;
    private final TransferService transferService;

    protected TransferServiceAdaptor(IntFunction<StopLocation> stopLookup, TransferService transferService) {
        this.stopLookup = stopLookup;
        this.transferService = transferService;
    }

    public static <T extends RaptorTripSchedule> TransferServiceAdaptor<T> create(IntFunction<StopLocation> stopLookup, TransferService transferService) {
        return new TransferServiceAdaptor<T>(stopLookup, transferService);
    }

    public static <T extends RaptorTripSchedule> TransferServiceAdaptor<T> noop() {
        return new TransferServiceAdaptor<T>(null, null){

            @Override
            protected ConstrainedTransfer findTransfer(TripStopTime<T> from, T toTrip, int toStop, int toStopPosition) {
                return null;
            }
        };
    }

    @Nullable
    protected ConstrainedTransfer findTransfer(TripStopTime<T> from, T toTrip, int toStop, int toStopPosition) {
        return this.transferService.findTransfer(this.trip(from.trip()), from.stopPosition(), this.stop(from.stop()), this.trip(toTrip), toStopPosition, this.stop(toStop));
    }

    private StopLocation stop(int index) {
        return this.stopLookup.apply(index);
    }

    private Trip trip(T raptorTripSchedule) {
        return ((TripSchedule)raptorTripSchedule).getOriginalTripTimes().getTrip();
    }
}

