/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.framework.logging.ThrottleLogger;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.routing.algorithm.raptoradapter.path.PathDiff;
import org.opentripplanner.routing.algorithm.transferoptimization.api.OptimizedPath;
import org.opentripplanner.routing.algorithm.transferoptimization.model.MinSafeTransferTimeCalculator;
import org.opentripplanner.routing.algorithm.transferoptimization.model.TransferWaitTimeCostCalculator;
import org.opentripplanner.routing.algorithm.transferoptimization.services.OptimizePathDomainService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizeTransferService<T extends RaptorTripSchedule> {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizeTransferService.class);
    private static final Logger OPTIMIZATION_FAILED_LOG = ThrottleLogger.throttle(LOG);
    private final OptimizePathDomainService<T> optimizePathDomainService;
    private final MinSafeTransferTimeCalculator<T> minSafeTransferTimeCalculator;
    private final TransferWaitTimeCostCalculator transferWaitTimeCostCalculator;

    public OptimizeTransferService(OptimizePathDomainService<T> optimizePathDomainService, MinSafeTransferTimeCalculator<T> minSafeTransferTimeCalculator, TransferWaitTimeCostCalculator transferWaitTimeCostCalculator) {
        this.optimizePathDomainService = optimizePathDomainService;
        this.minSafeTransferTimeCalculator = minSafeTransferTimeCalculator;
        this.transferWaitTimeCostCalculator = transferWaitTimeCostCalculator;
    }

    public OptimizeTransferService(OptimizePathDomainService<T> optimizePathDomainService) {
        this.optimizePathDomainService = optimizePathDomainService;
        this.minSafeTransferTimeCalculator = null;
        this.transferWaitTimeCostCalculator = null;
    }

    public List<RaptorPath<T>> optimize(Collection<RaptorPath<T>> paths) {
        this.setup(paths);
        long start = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        ArrayList<RaptorPath<T>> results = new ArrayList<RaptorPath<T>>();
        for (RaptorPath<T> path : paths) {
            results.addAll(this.optimize(path));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Optimized transfers done in {} ms.", (Object)(System.currentTimeMillis() - start));
            PathDiff.logDiff("RAPTOR", paths, "OPT", results, false, false, arg_0 -> ((Logger)LOG).debug(arg_0));
        }
        return results;
    }

    private void setup(Collection<RaptorPath<T>> paths) {
        if (this.transferWaitTimeCostCalculator != null) {
            this.transferWaitTimeCostCalculator.setMinSafeTransferTime(this.minSafeTransferTimeCalculator.minSafeTransferTime(paths));
        }
    }

    private Collection<OptimizedPath<T>> optimize(RaptorPath<T> path) {
        if (path.numberOfTransfersExAccessEgress() == 0) {
            return List.of(new OptimizedPath<T>(path));
        }
        try {
            return this.optimizePathDomainService.findBestTransitPath(path);
        }
        catch (RuntimeException e) {
            OPTIMIZATION_FAILED_LOG.error("Unable to optimize transfers in path. Details: {}, path: {}", new Object[]{e.getMessage(), path, e});
            return List.of(new OptimizedPath<T>(path));
        }
    }
}

