/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.raptor.spi.IntIterator;
import org.opentripplanner.raptor.spi.RaptorBoardOrAlightEvent;
import org.opentripplanner.raptor.spi.RaptorConstrainedBoardingSearch;
import org.opentripplanner.raptor.spi.RaptorTimeTable;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedBoardingSearchForward;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedBoardingSearchReverse;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedBoardingSearchStrategy;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedTransferBoarding;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferForPattern;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferForPatternByStopPos;
import org.opentripplanner.transit.model.timetable.Trip;

public final class ConstrainedBoardingSearch
implements RaptorConstrainedBoardingSearch<TripSchedule> {
    private static final int ABORT_SEARCH_AFTER_N_VALID_NORMAL_TRIPS = 5;
    private static final ConstrainedBoardingSearchStrategy FORWARD_STRATEGY = new ConstrainedBoardingSearchForward();
    private static final ConstrainedBoardingSearchStrategy REVERSE_STRATEGY = new ConstrainedBoardingSearchReverse();
    public static final RaptorConstrainedBoardingSearch<TripSchedule> NOOP_SEARCH = new NoopRaptorConstrainedBoardingSearch();
    private final ConstrainedBoardingSearchStrategy searchStrategy;
    @Nullable
    private final TransferForPatternByStopPos transfersToTargetStop;
    @Nullable
    private final TransferForPatternByStopPos transfersFromSourceStop;
    private List<TransferForPattern> currentTransfers;
    private int currentTargetStopPos;
    private int onTripEarliestBoardTime;
    private int onTripIndex;
    private TransferConstraint onTripTxConstraint;

    public ConstrainedBoardingSearch(boolean forwardSearch, @Nullable TransferForPatternByStopPos transfersFromSourceStop, @Nullable TransferForPatternByStopPos transfersToTargetStop) {
        this.transfersToTargetStop = transfersToTargetStop;
        this.transfersFromSourceStop = transfersFromSourceStop;
        this.searchStrategy = forwardSearch ? FORWARD_STRATEGY : REVERSE_STRATEGY;
    }

    @Override
    public boolean transferExistTargetStop(int targetStopPos) {
        if (this.transfersToTargetStop == null) {
            return false;
        }
        this.currentTransfers = this.transfersToTargetStop.get(targetStopPos);
        this.currentTargetStopPos = targetStopPos;
        return this.currentTransfers != null;
    }

    @Override
    public boolean transferExistSourceStop(int sourceStopPos) {
        return this.transfersFromSourceStop != null && this.transfersFromSourceStop.get(sourceStopPos) != null;
    }

    @Override
    public RaptorBoardOrAlightEvent<TripSchedule> find(RaptorTimeTable<TripSchedule> timetable, int transferSlack, TripSchedule sourceTripSchedule, int sourceStopIndex, int prevTransitArrivalTime, int earliestBoardTime) {
        Iterable<TransferForPattern> transfers = this.findMatchingTransfers(sourceTripSchedule, sourceStopIndex);
        if (!transfers.iterator().hasNext()) {
            return RaptorBoardOrAlightEvent.empty(earliestBoardTime);
        }
        boolean found = this.findTimetableTripInfo(timetable, transfers, transferSlack, this.currentTargetStopPos, prevTransitArrivalTime, earliestBoardTime);
        if (!found) {
            return RaptorBoardOrAlightEvent.empty(earliestBoardTime);
        }
        TripSchedule trip = timetable.getTripSchedule(this.onTripIndex);
        int departureTime = this.searchStrategy.time(trip, this.currentTargetStopPos);
        return new ConstrainedTransferBoarding<TripSchedule>(this.onTripTxConstraint, this.onTripIndex, trip, this.currentTargetStopPos, departureTime, this.onTripEarliestBoardTime);
    }

    private Iterable<TransferForPattern> findMatchingTransfers(TripSchedule tripSchedule, int stopIndex) {
        Trip trip = tripSchedule.getOriginalTripTimes().getTrip();
        LinkedList<TransferForPattern> result = new LinkedList<TransferForPattern>();
        for (TransferForPattern t : this.currentTransfers) {
            if (!t.matchesSourcePoint(stopIndex, trip)) continue;
            result.add(t);
        }
        return result;
    }

    private boolean findTimetableTripInfo(RaptorTimeTable<TripSchedule> timetable, Iterable<TransferForPattern> transfers, int transferSlack, int stopPos, int sourceTransitArrivalTime, int earliestBoardTime) {
        int nAllowedBoardings = 0;
        boolean useNextNormalTrip = false;
        IntIterator index = this.searchStrategy.scheduleIndexIterator(timetable);
        block0: while (index.hasNext()) {
            this.onTripIndex = index.next();
            TripSchedule it = timetable.getTripSchedule(this.onTripIndex);
            int time = this.searchStrategy.time(it, stopPos);
            if (this.searchStrategy.timeIsBefore(time, sourceTransitArrivalTime)) continue;
            ++nAllowedBoardings;
            Trip targetTrip = it.getOriginalTripTimes().getTrip();
            for (TransferForPattern tx : transfers) {
                this.onTripTxConstraint = (TransferConstraint)tx.getTransferConstraint();
                this.onTripEarliestBoardTime = this.onTripTxConstraint.calculateTransferTargetTime(sourceTransitArrivalTime, transferSlack, () -> earliestBoardTime, this.searchStrategy.direction());
                if (!this.onTripTxConstraint.isFacilitated() && this.searchStrategy.timeIsBefore(time, this.onTripEarliestBoardTime)) continue;
                if (tx.applyToAllTargetTrips()) {
                    return true;
                }
                if (!tx.applyToTargetTrip(targetTrip)) continue;
                if (this.onTripTxConstraint.isNotAllowed()) {
                    useNextNormalTrip = true;
                    continue block0;
                }
                return true;
            }
            if (useNextNormalTrip) {
                this.onTripEarliestBoardTime = earliestBoardTime;
                this.onTripTxConstraint = TransferConstraint.REGULAR_TRANSFER;
                return true;
            }
            if (nAllowedBoardings != 5) continue;
            return false;
        }
        return false;
    }

    private static final class NoopRaptorConstrainedBoardingSearch
    implements RaptorConstrainedBoardingSearch<TripSchedule> {
        private NoopRaptorConstrainedBoardingSearch() {
        }

        @Override
        public boolean transferExistTargetStop(int targetStopPos) {
            return false;
        }

        @Override
        public boolean transferExistSourceStop(int targetStopPos) {
            return false;
        }

        @Override
        public RaptorBoardOrAlightEvent<TripSchedule> find(RaptorTimeTable<TripSchedule> targetTimetable, int transferSlack, TripSchedule sourceTrip, int sourceStopIndex, int prevTransitArrivalTime, int earliestBoardTime) {
            return null;
        }
    }
}

