/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.framework.time.ServiceDateUtils;
import org.opentripplanner.transit.model.network.RoutingTripPattern;
import org.opentripplanner.transit.model.timetable.FrequencyEntry;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripPatternForDate
implements Comparable<TripPatternForDate> {
    private static final Logger LOG = LoggerFactory.getLogger(TripPatternForDate.class);
    private final RoutingTripPattern tripPattern;
    private final TripTimes[] tripTimes;
    private final FrequencyEntry[] frequencies;
    private final LocalDate localDate;
    private final LocalDate startOfRunningPeriod;
    private final LocalDate endOfRunningPeriod;

    public TripPatternForDate(RoutingTripPattern tripPattern, List<TripTimes> tripTimes, List<FrequencyEntry> frequencies, LocalDate localDate) {
        this.tripPattern = tripPattern;
        this.tripTimes = tripTimes.toArray(new TripTimes[0]);
        this.frequencies = frequencies.toArray(new FrequencyEntry[0]);
        this.localDate = localDate;
        if (this.hasFrequencies()) {
            this.startOfRunningPeriod = ServiceDateUtils.asDateTime(localDate, frequencies.stream().mapToInt(frequencyEntry -> frequencyEntry.startTime).min().orElseThrow()).toLocalDate();
            this.endOfRunningPeriod = ServiceDateUtils.asDateTime(localDate, frequencies.stream().mapToInt(frequencyEntry -> frequencyEntry.endTime).max().orElseThrow()).toLocalDate();
        } else {
            TripTimes first = tripTimes.get(0);
            this.startOfRunningPeriod = ServiceDateUtils.asDateTime(localDate, first.getDepartureTime(0)).toLocalDate();
            TripTimes last = tripTimes.get(tripTimes.size() - 1);
            this.endOfRunningPeriod = ServiceDateUtils.asDateTime(localDate, last.getArrivalTime(last.getNumStops() - 1)).toLocalDate();
            TripPatternForDate.assertValidRunningPeriod(this.startOfRunningPeriod, this.endOfRunningPeriod, first, last);
        }
    }

    public List<TripTimes> tripTimes() {
        return Arrays.asList(this.tripTimes);
    }

    public List<FrequencyEntry> getFrequencies() {
        return Arrays.asList(this.frequencies);
    }

    public RoutingTripPattern getTripPattern() {
        return this.tripPattern;
    }

    public int stopIndex(int i) {
        return this.tripPattern.stopIndex(i);
    }

    public TripTimes getTripTimes(int i) {
        return this.tripTimes[i];
    }

    public LocalDate getLocalDate() {
        return this.localDate;
    }

    public int numberOfTripSchedules() {
        return this.tripTimes.length;
    }

    public LocalDate getStartOfRunningPeriod() {
        return this.startOfRunningPeriod;
    }

    public List<LocalDate> getRunningPeriodDates() {
        return this.startOfRunningPeriod.datesUntil(this.endOfRunningPeriod.plusDays(1L)).collect(Collectors.toList());
    }

    public boolean hasFrequencies() {
        return this.frequencies.length != 0;
    }

    @Override
    public int compareTo(TripPatternForDate other) {
        return this.localDate.compareTo(other.localDate);
    }

    public int hashCode() {
        return Objects.hash(this.tripPattern, this.localDate, Arrays.hashCode(this.tripTimes), Arrays.hashCode(this.frequencies));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TripPatternForDate that = (TripPatternForDate)o;
        return this.tripPattern.equals(that.tripPattern) && this.localDate.equals(that.localDate) && Arrays.equals(this.tripTimes, that.tripTimes) && Arrays.equals(this.frequencies, that.frequencies);
    }

    public String toString() {
        return "TripPatternForDate{tripPattern=" + this.tripPattern + ", localDate=" + this.localDate + "}";
    }

    @Nullable
    public TripPatternForDate newWithFilteredTripTimes(Predicate<TripTimes> filter) {
        ArrayList<TripTimes> filteredTripTimes = new ArrayList<TripTimes>(this.tripTimes.length);
        for (TripTimes tripTimes : this.tripTimes) {
            if (!filter.test(tripTimes)) continue;
            filteredTripTimes.add(tripTimes);
        }
        ArrayList<FrequencyEntry> filteredFrequencies = new ArrayList<FrequencyEntry>(this.frequencies.length);
        for (FrequencyEntry frequencyEntry : this.frequencies) {
            if (!filter.test(frequencyEntry.tripTimes)) continue;
            filteredFrequencies.add(frequencyEntry);
        }
        if (filteredTripTimes.isEmpty() && filteredFrequencies.isEmpty()) {
            return null;
        }
        if (this.tripTimes.length == filteredTripTimes.size() && this.frequencies.length == filteredFrequencies.size()) {
            return this;
        }
        return new TripPatternForDate(this.tripPattern, filteredTripTimes, filteredFrequencies, this.localDate);
    }

    private static void assertValidRunningPeriod(LocalDate startOfRunningPeriod, LocalDate endOfRunningPeriod, TripTimes first, TripTimes last) {
        if (first.getTrip().getRoute().getFlexibleLineType() != null) {
            return;
        }
        if (startOfRunningPeriod.isAfter(endOfRunningPeriod)) {
            LOG.warn("Could not construct as start of the running period {} in trip {} is after the end {} in trip {}", new Object[]{startOfRunningPeriod, first.getTrip().getId(), endOfRunningPeriod, last.getTrip().getId()});
            throw new IllegalArgumentException("Start of the running period is after end of the running period");
        }
    }
}

