/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import javax.annotation.Nullable;
import org.opentripplanner.ext.flex.FlexAccessEgress;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.DefaultAccessEgress;

public class FlexAccessEgressAdapter
extends DefaultAccessEgress {
    private final FlexAccessEgress flexAccessEgress;

    public FlexAccessEgressAdapter(FlexAccessEgress flexAccessEgress, boolean isEgress) {
        super(flexAccessEgress.stop.getIndex(), isEgress ? flexAccessEgress.lastState.reverse() : flexAccessEgress.lastState);
        this.flexAccessEgress = flexAccessEgress;
    }

    @Override
    public int earliestDepartureTime(int requestedDepartureTime) {
        return FlexAccessEgressAdapter.mapToRaptorTime(this.flexAccessEgress.earliestDepartureTime(requestedDepartureTime));
    }

    @Override
    public int latestArrivalTime(int requestedArrivalTime) {
        return FlexAccessEgressAdapter.mapToRaptorTime(this.flexAccessEgress.latestArrivalTime(requestedArrivalTime));
    }

    @Override
    public int numberOfRides() {
        return 1;
    }

    @Override
    public boolean stopReachedOnBoard() {
        return this.flexAccessEgress.directToStop;
    }

    @Override
    public boolean hasOpeningHours() {
        return true;
    }

    @Override
    @Nullable
    public String openingHoursToString() {
        return "TODO";
    }

    @Override
    public String toString() {
        return this.asString(true);
    }

    private static int mapToRaptorTime(int flexTime) {
        return flexTime == -999 ? -1999000000 : flexTime;
    }
}

