/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.StopArrival;
import org.opentripplanner.routing.alertpatch.StopCondition;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;

public class AlertToLegMapper {
    private final TransitAlertService transitAlertService;
    private final Function<Station, MultiModalStation> getMultiModalStation;

    public AlertToLegMapper(TransitAlertService transitAlertService, Function<Station, MultiModalStation> getMultiModalStation) {
        this.transitAlertService = transitAlertService;
        this.getMultiModalStation = getMultiModalStation;
    }

    public void addTransitAlertsToLeg(Leg leg, boolean isFirstLeg) {
        Collection<TransitAlert> alerts;
        Set<StopCondition> stopConditions;
        RegularStop stop;
        if (!leg.isTransitLeg()) {
            return;
        }
        ZonedDateTime legStartTime = leg.getStartTime();
        ZonedDateTime legEndTime = leg.getEndTime();
        StopLocation fromStop = leg.getFrom() == null ? null : leg.getFrom().stop;
        StopLocation toStop = leg.getTo() == null ? null : leg.getTo().stop;
        FeedScopedId routeId = leg.getRoute().getId();
        FeedScopedId tripId = leg.getTrip().getId();
        LocalDate serviceDate = leg.getServiceDate();
        if (fromStop instanceof RegularStop) {
            stop = (RegularStop)fromStop;
            stopConditions = isFirstLeg ? StopCondition.FIRST_DEPARTURE : StopCondition.DEPARTURE;
            alerts = this.getAlertsForStopAndRoute(stop, routeId, stopConditions);
            alerts.addAll(this.getAlertsForStopAndTrip(stop, tripId, serviceDate, stopConditions));
            alerts.addAll(this.getAlertsForRelatedStops(stop, id -> this.transitAlertService.getStopAlerts((FeedScopedId)id, stopConditions)));
            AlertToLegMapper.addTransitAlertsToLeg(leg, alerts, legStartTime, legEndTime);
        }
        if (toStop instanceof RegularStop) {
            stop = (RegularStop)toStop;
            stopConditions = StopCondition.ARRIVING;
            alerts = this.getAlertsForStopAndRoute(stop, routeId, stopConditions);
            alerts.addAll(this.getAlertsForStopAndTrip(stop, tripId, serviceDate, stopConditions));
            alerts.addAll(this.getAlertsForRelatedStops(stop, id -> this.transitAlertService.getStopAlerts((FeedScopedId)id, stopConditions)));
            AlertToLegMapper.addTransitAlertsToLeg(leg, alerts, legStartTime, legEndTime);
        }
        if (leg.getIntermediateStops() != null) {
            Set<StopCondition> stopConditions2 = StopCondition.PASSING;
            for (StopArrival visit : leg.getIntermediateStops()) {
                StopLocation stopLocation = visit.place.stop;
                if (!(stopLocation instanceof RegularStop)) continue;
                RegularStop stop2 = (RegularStop)stopLocation;
                Collection<TransitAlert> alerts2 = this.getAlertsForStopAndRoute(stop2, routeId, stopConditions2);
                alerts2.addAll(this.getAlertsForStopAndTrip(stop2, tripId, serviceDate, stopConditions2));
                alerts2.addAll(this.getAlertsForRelatedStops(stop2, id -> this.transitAlertService.getStopAlerts((FeedScopedId)id, stopConditions2)));
                ZonedDateTime stopArrival = visit.arrival;
                ZonedDateTime stopDeparture = visit.departure;
                AlertToLegMapper.addTransitAlertsToLeg(leg, alerts2, stopArrival, stopDeparture);
            }
        }
        Collection<TransitAlert> alerts3 = this.transitAlertService.getTripAlerts(leg.getTrip().getId(), serviceDate);
        AlertToLegMapper.addTransitAlertsToLeg(leg, alerts3, legStartTime, legEndTime);
        alerts3 = this.transitAlertService.getRouteAlerts(leg.getRoute().getId());
        AlertToLegMapper.addTransitAlertsToLeg(leg, alerts3, legStartTime, legEndTime);
        alerts3 = this.transitAlertService.getAgencyAlerts(leg.getAgency().getId());
        AlertToLegMapper.addTransitAlertsToLeg(leg, alerts3, legStartTime, legEndTime);
        leg.getTransitAlerts().removeIf(alert -> !alert.displayDuring(leg.getStartTime().toEpochSecond(), leg.getEndTime().toEpochSecond()));
    }

    private static void addTransitAlertsToLeg(Leg leg, Collection<TransitAlert> alerts, ZonedDateTime fromTime, ZonedDateTime toTime) {
        if (alerts != null) {
            for (TransitAlert alert : alerts) {
                if (!alert.displayDuring(fromTime.toEpochSecond(), toTime.toEpochSecond())) continue;
                leg.addAlert(alert);
            }
        }
    }

    private Collection<TransitAlert> getAlertsForStopAndRoute(RegularStop stop, FeedScopedId routeId, Set<StopCondition> stopConditions) {
        return this.getAlertsForRelatedStops(stop, id -> this.transitAlertService.getStopAndRouteAlerts((FeedScopedId)id, routeId, stopConditions));
    }

    private Collection<TransitAlert> getAlertsForStopAndTrip(RegularStop stop, FeedScopedId tripId, LocalDate serviceDate, Set<StopCondition> stopConditions) {
        return this.getAlertsForRelatedStops(stop, id -> this.transitAlertService.getStopAndTripAlerts((FeedScopedId)id, tripId, serviceDate, stopConditions));
    }

    private Collection<TransitAlert> getAlertsForRelatedStops(RegularStop stop, Function<FeedScopedId, Collection<TransitAlert>> getAlertsForStop) {
        if (stop == null) {
            return new ArrayList<TransitAlert>();
        }
        Collection<TransitAlert> alertsForStop = getAlertsForStop.apply(stop.getId());
        if (alertsForStop == null) {
            alertsForStop = new HashSet<TransitAlert>();
        }
        if (stop.isPartOfStation()) {
            Collection<TransitAlert> multimodalStopAlerts;
            Station parentStation = stop.getParentStation();
            Collection<TransitAlert> parentStopAlerts = getAlertsForStop.apply(parentStation.getId());
            if (parentStopAlerts != null) {
                alertsForStop.addAll(parentStopAlerts);
            }
            for (StopLocation siblingStop : parentStation.getChildStops()) {
                Collection<TransitAlert> siblingAlerts;
                if (stop.getId().equals(siblingStop.getId()) || (siblingAlerts = getAlertsForStop.apply(parentStation.getId())) == null) continue;
                alertsForStop.addAll(siblingAlerts);
            }
            MultiModalStation multiModalStation = this.getMultiModalStation.apply(parentStation);
            if (multiModalStation != null && (multimodalStopAlerts = getAlertsForStop.apply(multiModalStation.getId())) != null) {
                alertsForStop.addAll(multimodalStopAlerts);
            }
        }
        return alertsForStop;
    }
}

