/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.deletionflagger;

import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.api.TransitGeneralizedCostFilterParams;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.ItineraryDeletionFlagger;
import org.opentripplanner.routing.api.request.framework.DoubleAlgorithmFunction;

public class TransitGeneralizedCostFilter
implements ItineraryDeletionFlagger {
    private final DoubleAlgorithmFunction costLimitFunction;
    private final double intervalRelaxFactor;

    public TransitGeneralizedCostFilter(TransitGeneralizedCostFilterParams params) {
        this.costLimitFunction = params.costLimitFunction();
        this.intervalRelaxFactor = params.intervalRelaxFactor();
    }

    @Override
    public String name() {
        return "transit-cost-filter";
    }

    @Override
    public List<Itinerary> flagForRemoval(List<Itinerary> itineraries) {
        List<Itinerary> transitItineraries = itineraries.stream().filter(Itinerary::hasTransit).sorted(Comparator.comparingDouble(Itinerary::getGeneralizedCost)).toList();
        return transitItineraries.stream().filter(it -> transitItineraries.stream().anyMatch(t -> (double)it.getGeneralizedCost() > this.costLimitFunction.calculate(t.getGeneralizedCost()) + this.getWaitTimeCost((Itinerary)t, (Itinerary)it))).collect(Collectors.toList());
    }

    private double getWaitTimeCost(Itinerary a, Itinerary b) {
        return this.intervalRelaxFactor * (double)Math.min(Math.abs(ChronoUnit.SECONDS.between(a.startTime(), b.startTime())), Math.abs(ChronoUnit.SECONDS.between(a.endTime(), b.endTime())));
    }
}

