/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.deletionflagger;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.StreetLeg;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.ItineraryDeletionFlagger;
import org.opentripplanner.street.search.TraverseMode;

public class RemoveParkAndRideWithMostlyWalkingFilter
implements ItineraryDeletionFlagger {
    private final double parkAndRideDurationRatio;

    public RemoveParkAndRideWithMostlyWalkingFilter(double ratio) {
        this.parkAndRideDurationRatio = ratio;
    }

    @Override
    public String name() {
        return "park-and-ride-vs-walk-filter";
    }

    @Override
    public Predicate<Itinerary> shouldBeFlaggedForRemoval() {
        return itinerary -> {
            boolean containsTransit = itinerary.getLegs().stream().anyMatch(l -> l != null && l.isTransitLeg());
            double carDuration = itinerary.getLegs().stream().filter(StreetLeg.class::isInstance).map(StreetLeg.class::cast).filter(l -> l.getMode() == TraverseMode.CAR).mapToDouble(l -> l.getDuration().toSeconds()).sum();
            double totalDuration = itinerary.getDuration().toSeconds();
            return !containsTransit && carDuration != 0.0 && carDuration / totalDuration <= this.parkAndRideDurationRatio;
        };
    }

    @Override
    public List<Itinerary> flagForRemoval(List<Itinerary> itineraries) {
        if (itineraries.size() == 1) {
            return List.of();
        }
        return itineraries.stream().filter(this.shouldBeFlaggedForRemoval()).collect(Collectors.toList());
    }
}

