/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.deletionflagger;

import java.util.List;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.algorithm.filterchain.ItineraryListFilter;
import org.opentripplanner.street.search.TraverseMode;

public class RemoveItinerariesWithShortStreetLeg
implements ItineraryListFilter {
    private final double minDistance;
    private final TraverseMode traverseMode;

    public RemoveItinerariesWithShortStreetLeg(double minDistance, TraverseMode traverseMode) {
        this.minDistance = minDistance;
        this.traverseMode = traverseMode;
    }

    @Override
    public List<Itinerary> filter(List<Itinerary> itineraries) {
        return itineraries.stream().filter(this::filterItinerariesWithShortStreetLeg).toList();
    }

    private boolean filterItinerariesWithShortStreetLeg(Itinerary itinerary) {
        boolean hasLegsOfMode = itinerary.getStreetLegs().anyMatch(l -> l.getMode().equals((Object)this.traverseMode));
        if (hasLegsOfMode && itinerary.hasTransit()) {
            double distance = itinerary.getStreetLegs().filter((? super T l) -> l.getMode().equals((Object)this.traverseMode)).mapToDouble(Leg::getDistanceMeters).sum();
            return distance > this.minDistance;
        }
        return true;
    }
}

