/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.deletionflagger;

import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.ItineraryDeletionFlagger;

public class OtherThanSameLegsMaxGeneralizedCostFilter
implements ItineraryDeletionFlagger {
    private final double maxCostOtherLegsFactor;

    public OtherThanSameLegsMaxGeneralizedCostFilter(double maxCostOtherLegsFactor) {
        this.maxCostOtherLegsFactor = maxCostOtherLegsFactor;
    }

    @Override
    public String name() {
        return "other-than-same-legs-max-generalized-cost-filter";
    }

    @Override
    public List<Itinerary> flagForRemoval(List<Itinerary> itineraries) {
        if (itineraries.size() < 2) {
            return List.of();
        }
        Function<Itinerary, Set> getTripsForItinerary = itinerary -> itinerary.getLegs().stream().filter(Leg::isTransitLeg).map(Leg::getTrip).collect(Collectors.toSet());
        Set commonTrips = itineraries.stream().map(getTripsForItinerary).reduce((a, b) -> {
            a.retainAll((Collection<?>)b);
            return a;
        }).get();
        OptionalInt commonCost = itineraries.stream().mapToInt(itinerary -> itinerary.getLegs().stream().filter(Leg::isTransitLeg).filter(leg -> commonTrips.contains(leg.getTrip())).mapToInt(leg -> leg.getGeneralizedCost()).sum()).min();
        if (commonCost.isEmpty()) {
            return List.of();
        }
        OptionalInt minimumCost = itineraries.stream().mapToInt(itinerary -> itinerary.getGeneralizedCost()).min();
        if (minimumCost.isEmpty()) {
            return List.of();
        }
        double maxLimit = (double)(minimumCost.getAsInt() - commonCost.getAsInt()) * this.maxCostOtherLegsFactor + (double)commonCost.getAsInt();
        return itineraries.stream().filter(it -> (double)it.getGeneralizedCost() > maxLimit).collect(Collectors.toList());
    }
}

