/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.deletionflagger;

import java.util.List;
import java.util.function.Consumer;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.ListSection;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.ItineraryDeletionFlagger;

public class MaxLimitFilter
implements ItineraryDeletionFlagger {
    private static final Consumer<Itinerary> IGNORE_SUBSCRIBER = i -> {};
    private final String name;
    private final int maxLimit;
    private final ListSection cropSection;
    private final Consumer<Itinerary> changedSubscriber;

    public MaxLimitFilter(String name, int maxLimit) {
        this(name, maxLimit, ListSection.TAIL, IGNORE_SUBSCRIBER);
    }

    public MaxLimitFilter(String name, int maxLimit, ListSection cropSection, Consumer<Itinerary> changedSubscriber) {
        this.name = name;
        this.maxLimit = maxLimit;
        this.cropSection = cropSection;
        this.changedSubscriber = changedSubscriber == null ? IGNORE_SUBSCRIBER : changedSubscriber;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<Itinerary> flagForRemoval(List<Itinerary> itineraries) {
        if (itineraries.size() <= this.maxLimit) {
            return List.of();
        }
        if (this.cropSection == ListSection.HEAD) {
            int limit = itineraries.size() - this.maxLimit;
            this.changedSubscriber.accept(itineraries.get(limit - 1));
            return itineraries.subList(0, limit);
        }
        this.changedSubscriber.accept(itineraries.get(this.maxLimit));
        return itineraries.subList(this.maxLimit, itineraries.size());
    }
}

