/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.alertpatch;

import java.time.LocalDate;
import java.util.Set;
import org.opentripplanner.routing.alertpatch.EntityKey;
import org.opentripplanner.routing.alertpatch.StopCondition;
import org.opentripplanner.routing.alertpatch.StopConditionsHelper;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.timetable.Direction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface EntitySelector {
    public EntityKey key();

    default public boolean matches(EntitySelector other) {
        return this.equals(other);
    }

    public record DirectionAndRoute(FeedScopedId routeId, Direction direction) implements EntitySelector
    {
        @Override
        public EntityKey.DirectionAndRoute key() {
            return new EntityKey.DirectionAndRoute(this.routeId, this.direction);
        }
    }

    public record RouteTypeAndAgency(FeedScopedId agencyId, int routeType) implements EntitySelector
    {
        @Override
        public EntityKey.RouteTypeAndAgency key() {
            return new EntityKey.RouteTypeAndAgency(this.agencyId, this.routeType);
        }
    }

    public record RouteType(String feedId, int routeType) implements EntitySelector
    {
        @Override
        public EntityKey.RouteType key() {
            return new EntityKey.RouteType(this.feedId, this.routeType);
        }
    }

    public record Unknown(String description) implements EntitySelector
    {
        @Override
        public EntityKey.Unknown key() {
            return new EntityKey.Unknown();
        }
    }

    public record StopAndTrip(FeedScopedId stopId, FeedScopedId tripId, LocalDate serviceDate, Set<StopCondition> stopConditions) implements EntitySelector
    {
        public StopAndTrip(FeedScopedId stopId, FeedScopedId tripId) {
            this(stopId, tripId, null, Set.of());
        }

        public StopAndTrip(FeedScopedId stopId, FeedScopedId tripId, LocalDate serviceDate) {
            this(stopId, tripId, serviceDate, Set.of());
        }

        @Override
        public EntityKey.StopAndTrip key() {
            return new EntityKey.StopAndTrip(this.stopId, this.tripId);
        }

        @Override
        public boolean matches(EntitySelector other) {
            if (!(other instanceof StopAndTrip)) {
                return false;
            }
            StopAndTrip s = (StopAndTrip)other;
            return this.stopId.equals(s.stopId) && this.tripId.equals(s.tripId) && StopConditionsHelper.matchesStopCondition(this.stopConditions, s.stopConditions) && (this.serviceDate == null || s.serviceDate == null || this.serviceDate.equals(s.serviceDate));
        }
    }

    public record StopAndRoute(FeedScopedId stopId, FeedScopedId routeId, Set<StopCondition> stopConditions) implements EntitySelector
    {
        public StopAndRoute(FeedScopedId stopId, FeedScopedId routeId) {
            this(stopId, routeId, Set.of());
        }

        public StopAndRoute(FeedScopedId stopId, Set<StopCondition> stopConditions, FeedScopedId routeId) {
            this(stopId, routeId, stopConditions);
        }

        @Override
        public EntityKey.StopAndRoute key() {
            return new EntityKey.StopAndRoute(this.stopId, this.routeId);
        }

        @Override
        public boolean matches(EntitySelector other) {
            if (!(other instanceof StopAndRoute)) {
                return false;
            }
            StopAndRoute s = (StopAndRoute)other;
            return this.stopId.equals(s.stopId) && this.routeId.equals(s.routeId) && StopConditionsHelper.matchesStopCondition(this.stopConditions, s.stopConditions);
        }
    }

    public record Trip(FeedScopedId tripId, LocalDate serviceDate) implements EntitySelector
    {
        public Trip(FeedScopedId tripId) {
            this(tripId, null);
        }

        @Override
        public EntityKey.Trip key() {
            return new EntityKey.Trip(this.tripId);
        }

        @Override
        public boolean matches(EntitySelector other) {
            if (!(other instanceof Trip)) {
                return false;
            }
            Trip t = (Trip)other;
            return this.tripId.equals(t.tripId) && (this.serviceDate == null || t.serviceDate == null || this.serviceDate.equals(t.serviceDate));
        }
    }

    public record Route(FeedScopedId routeId) implements EntitySelector
    {
        @Override
        public EntityKey.Route key() {
            return new EntityKey.Route(this.routeId);
        }
    }

    public record Stop(FeedScopedId stopId, Set<StopCondition> stopConditions) implements EntitySelector
    {
        public Stop(FeedScopedId stopId) {
            this(stopId, Set.of());
        }

        @Override
        public EntityKey.Stop key() {
            return new EntityKey.Stop(this.stopId);
        }

        @Override
        public boolean matches(EntitySelector other) {
            if (!(other instanceof Stop)) {
                return false;
            }
            Stop s = (Stop)other;
            return this.stopId.equals(s.stopId) && StopConditionsHelper.matchesStopCondition(this.stopConditions, s.stopConditions);
        }
    }

    public record Agency(FeedScopedId agencyId) implements EntitySelector
    {
        @Override
        public EntityKey.Agency key() {
            return new EntityKey.Agency(this.agencyId);
        }
    }
}

