/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.util.paretoset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.raptor.util.paretoset.ParetoSetEventListener;

public class ParetoSetEventListenerComposite<T>
implements ParetoSetEventListener<T> {
    private final List<ParetoSetEventListener<T>> listeners = new ArrayList<ParetoSetEventListener<T>>();

    @SafeVarargs
    public ParetoSetEventListenerComposite(ParetoSetEventListener<T> ... listeners) {
        this(Arrays.asList(listeners));
    }

    private ParetoSetEventListenerComposite(Collection<? extends ParetoSetEventListener<T>> listeners) {
        this.listeners.addAll(listeners);
    }

    @Override
    public void notifyElementAccepted(T newElement) {
        for (ParetoSetEventListener<T> it : this.listeners) {
            it.notifyElementAccepted(newElement);
        }
    }

    @Override
    public void notifyElementDropped(T element, T droppedByElement) {
        for (ParetoSetEventListener<T> it : this.listeners) {
            it.notifyElementDropped(element, droppedByElement);
        }
    }

    @Override
    public void notifyElementRejected(T element, T rejectedByElement) {
        for (ParetoSetEventListener<T> it : this.listeners) {
            it.notifyElementRejected(element, rejectedByElement);
        }
    }
}

