/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.util.paretoset;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opentripplanner.raptor.util.paretoset.ParetoComparator;
import org.opentripplanner.raptor.util.paretoset.ParetoSetEventListener;

public class ParetoSet<T>
extends AbstractCollection<T> {
    private final ParetoComparator<T> comparator;
    private final ParetoSetEventListener<? super T> eventListener;
    private T[] elements = new Object[16];
    private int size = 0;
    private T goodElement = null;

    public ParetoSet(ParetoComparator<T> comparator, ParetoSetEventListener<? super T> eventListener) {
        this.comparator = comparator;
        this.eventListener = eventListener;
    }

    public ParetoSet(ParetoComparator<T> comparator) {
        this(comparator, null);
    }

    public T get(int index) {
        return this.elements[index];
    }

    @Override
    public final Iterator<T> iterator() {
        return this.tailIterator(0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(T newValue) {
        if (this.size == 0) {
            this.acceptAndAppendValue(newValue);
            return true;
        }
        if (this.goodElement != null && this.leftVectorDominatesRightVector(this.goodElement, newValue)) {
            this.notifyElementRejected(newValue, this.goodElement);
            return false;
        }
        boolean mutualDominanceExist = false;
        boolean equivalentVectorExist = false;
        for (int i = 0; i < this.size; ++i) {
            T it = this.elements[i];
            boolean leftDominance = this.leftDominanceExist(newValue, it);
            boolean rightDominance = this.rightDominanceExist(newValue, it);
            if (leftDominance && rightDominance) {
                mutualDominanceExist = true;
                continue;
            }
            if (leftDominance) {
                this.removeDominatedElementsFromRestOfSetAndAddNewElement(newValue, i);
                return true;
            }
            if (rightDominance) {
                this.goodElement = this.elements[i];
                this.notifyElementRejected(newValue, it);
                return false;
            }
            equivalentVectorExist = true;
        }
        if (mutualDominanceExist && !equivalentVectorExist) {
            this.assertEnoughSpaceInSet();
            this.acceptAndAppendValue(newValue);
            return true;
        }
        this.notifyElementRejected(newValue, this.elements[0]);
        return false;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.size = 0;
        this.goodElement = null;
    }

    @Override
    public String toString() {
        return this.toString(Objects::toString);
    }

    public boolean qualify(T newValue) {
        if (this.size == 0) {
            return true;
        }
        if (this.goodElement != null && this.leftVectorDominatesRightVector(this.goodElement, newValue)) {
            this.notifyElementRejected(newValue, this.goodElement);
            return false;
        }
        boolean mutualDominanceExist = false;
        boolean equivalentVectorExist = false;
        for (int i = this.size - 1; i >= 0; --i) {
            boolean leftDominance = this.leftDominanceExist(newValue, this.elements[i]);
            boolean rightDominance = this.rightDominanceExist(newValue, this.elements[i]);
            if (leftDominance && rightDominance) {
                if (equivalentVectorExist) {
                    return false;
                }
                mutualDominanceExist = true;
                continue;
            }
            if (leftDominance) {
                return true;
            }
            if (rightDominance) {
                this.goodElement = this.elements[i];
                return false;
            }
            if (mutualDominanceExist) {
                return false;
            }
            equivalentVectorExist = true;
        }
        return mutualDominanceExist;
    }

    public final int internalArrayLength() {
        return this.elements.length;
    }

    public String toString(Function<? super T, String> toStringMapper) {
        return "{" + Arrays.stream(this.elements, 0, this.size).map(toStringMapper).collect(Collectors.joining(", ")) + "}";
    }

    protected void notifyElementMoved(int fromIndex, int toIndex) {
    }

    final Iterable<T> tail(int startIndexInclusive) {
        return () -> this.tailIterator(startIndexInclusive);
    }

    private Iterator<T> tailIterator(final int startInclusive) {
        return new Iterator<T>(){
            int i;
            {
                this.i = startInclusive;
            }

            @Override
            public boolean hasNext() {
                return this.i < ParetoSet.this.size;
            }

            @Override
            public T next() {
                return ParetoSet.this.elements[this.i++];
            }
        };
    }

    private void removeDominatedElementsFromRestOfSetAndAddNewElement(T newValue, int index) {
        int j;
        int i = index;
        this.notifyElementDropped(this.elements[i], newValue);
        for (j = index + 1; j < this.size; ++j) {
            this.notifyElementMoved(j, i);
            if (!this.leftVectorDominatesRightVector(newValue, this.elements[j])) {
                this.elements[i] = this.elements[j];
                ++i;
                continue;
            }
            this.notifyElementDropped(this.elements[j], newValue);
        }
        this.notifyElementMoved(j, i);
        this.notifyElementAccepted(newValue);
        this.elements[i] = newValue;
        this.size = i + 1;
    }

    private boolean leftVectorDominatesRightVector(T left, T right) {
        return this.leftDominanceExist(left, right) && !this.rightDominanceExist(left, right);
    }

    private void acceptAndAppendValue(T newValue) {
        this.notifyElementAccepted(newValue);
        this.elements[this.size++] = newValue;
    }

    private void assertEnoughSpaceInSet() {
        if (this.size == this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, this.elements.length * 2);
        }
    }

    private boolean leftDominanceExist(T left, T right) {
        return this.comparator.leftDominanceExist(left, right);
    }

    private boolean rightDominanceExist(T left, T right) {
        return this.comparator.leftDominanceExist(right, left);
    }

    private void notifyElementAccepted(T newElement) {
        if (this.eventListener != null) {
            this.eventListener.notifyElementAccepted(newElement);
        }
    }

    private void notifyElementDropped(T element, T droppedByElement) {
        if (this.eventListener != null) {
            this.eventListener.notifyElementDropped(element, droppedByElement);
        }
    }

    private void notifyElementRejected(T element, T rejectByElement) {
        if (this.eventListener != null) {
            this.eventListener.notifyElementRejected(element, rejectByElement);
        }
    }
}

