/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.spi;

import java.util.List;
import java.util.stream.Stream;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.AccessPathLeg;
import org.opentripplanner.raptor.api.path.EgressPathLeg;
import org.opentripplanner.raptor.api.path.PathLeg;
import org.opentripplanner.raptor.api.path.PathStringBuilder;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.api.path.RaptorStopNameResolver;
import org.opentripplanner.raptor.api.path.TransitPathLeg;

public class UnknownPath<T extends RaptorTripSchedule>
implements RaptorPath<T> {
    private final int departureTime;
    private final int arrivalTime;
    private final int numberOfTransfers;

    public UnknownPath(int sourceTime, int targetTime, int numberOfTransfers) {
        if (sourceTime <= targetTime) {
            this.departureTime = sourceTime;
            this.arrivalTime = targetTime;
        } else {
            this.departureTime = targetTime;
            this.arrivalTime = sourceTime;
        }
        this.numberOfTransfers = numberOfTransfers;
    }

    @Override
    public int rangeRaptorIterationDepartureTime() {
        return this.departureTime;
    }

    @Override
    public int startTime() {
        return this.departureTime;
    }

    @Override
    public int endTime() {
        return this.arrivalTime;
    }

    @Override
    public int durationInSeconds() {
        return this.arrivalTime - this.departureTime;
    }

    @Override
    public int numberOfTransfers() {
        return this.numberOfTransfers;
    }

    @Override
    public int numberOfTransfersExAccessEgress() {
        return this.numberOfTransfers;
    }

    @Override
    public int c1() {
        return 0;
    }

    @Override
    public AccessPathLeg<T> accessLeg() {
        return null;
    }

    @Override
    public EgressPathLeg<T> egressLeg() {
        return null;
    }

    @Override
    public List<Integer> listStops() {
        return List.of();
    }

    @Override
    public int waitTime() {
        return 0;
    }

    @Override
    public Stream<PathLeg<T>> legStream() {
        return Stream.empty();
    }

    @Override
    public Stream<TransitPathLeg<T>> transitLegs() {
        return Stream.empty();
    }

    @Override
    public boolean isUnknownPath() {
        return true;
    }

    @Override
    public String toStringDetailed(RaptorStopNameResolver stopNameResolver) {
        return this.toString();
    }

    @Override
    public String toString(RaptorStopNameResolver stopNameTranslator) {
        return this.toString();
    }

    public String toString() {
        PathStringBuilder pathBuilder = new PathStringBuilder(null);
        if (this.departureTime == 0 && this.arrivalTime == 0) {
            pathBuilder.summary(this.c1());
        } else {
            pathBuilder.summary(this.startTime(), this.endTime(), this.numberOfTransfers, this.c1());
        }
        return pathBuilder.toString();
    }
}

