/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.service;

import org.opentripplanner.raptor.api.request.RaptorProfile;
import org.opentripplanner.raptor.api.request.RaptorRequest;
import org.opentripplanner.raptor.api.request.SearchParams;

class HeuristicToRunResolver {
    HeuristicToRunResolver() {
    }

    static void resolveHeuristicToRunBasedOnOptimizationsAndSearchParameters(RaptorRequest<?> req, Runnable turnFwdOn, Runnable turnRevOn) {
        if (!req.profile().isOneOf(RaptorProfile.STANDARD, RaptorProfile.MULTI_CRITERIA)) {
            return;
        }
        boolean forward = false;
        boolean reverse = false;
        SearchParams s = req.searchParams();
        if (req.profile().is(RaptorProfile.MULTI_CRITERIA) && req.useDestinationPruning()) {
            reverse = true;
        }
        if (!s.isEarliestDepartureTimeSet()) {
            reverse = true;
        }
        if (!s.isSearchWindowSet() && !reverse) {
            forward = true;
        }
        if (forward) {
            turnFwdOn.run();
        }
        if (reverse) {
            turnRevOn.run();
        }
    }
}

