/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.service;

import org.opentripplanner.raptor.api.response.StopArrivals;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorkerResult;
import org.opentripplanner.raptor.rangeraptor.internalapi.SingleCriteriaStopArrivals;

public class DefaultStopArrivals
implements StopArrivals {
    private SingleCriteriaStopArrivals bestOverallArrivalTime = null;
    private SingleCriteriaStopArrivals bestTransitArrivalTime = null;
    private SingleCriteriaStopArrivals bestNumberOfTransfers = null;
    private final RaptorWorkerResult<?> results;

    public DefaultStopArrivals(RaptorWorkerResult<?> results) {
        this.results = results;
    }

    @Override
    public boolean reached(int stopIndex) {
        return this.bestOverallArrivalTime().isReached(stopIndex);
    }

    @Override
    public int bestArrivalTime(int stopIndex) {
        return this.bestOverallArrivalTime().value(stopIndex);
    }

    @Override
    public boolean reachedByTransit(int stopIndex) {
        return this.bestTransitArrivalTime().isReached(stopIndex);
    }

    @Override
    public int bestTransitArrivalTime(int stopIndex) {
        return this.bestTransitArrivalTime().value(stopIndex);
    }

    private SingleCriteriaStopArrivals bestOverallArrivalTime() {
        if (this.bestOverallArrivalTime == null) {
            this.bestOverallArrivalTime = this.results.extractBestOverallArrivals();
        }
        return this.bestOverallArrivalTime;
    }

    private SingleCriteriaStopArrivals bestTransitArrivalTime() {
        if (this.bestTransitArrivalTime == null) {
            this.bestTransitArrivalTime = this.results.extractBestTransitArrivals();
        }
        return this.bestTransitArrivalTime;
    }

    private SingleCriteriaStopArrivals bestNumberOfTransfers() {
        if (this.bestNumberOfTransfers == null) {
            this.bestNumberOfTransfers = this.results.extractBestNumberOfTransfers();
        }
        return this.bestNumberOfTransfers;
    }
}

