/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.transit;

import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTripPattern;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.rangeraptor.transit.TimeCalculator;

public interface TransitCalculator<T extends RaptorTripSchedule>
extends TimeCalculator {
    public int stopArrivalTime(T var1, int var2, int var3);

    public boolean boardingPossibleAt(RaptorTripPattern var1, int var2);

    public boolean alightingPossibleAt(RaptorTripPattern var1, int var2);

    public int departureTime(RaptorAccessEgress var1, int var2);

    default public int calculateEgressDepartureTime(int arrivalTime, RaptorAccessEgress egressPath, int transferSlack) {
        return TransitCalculator.calculateEgressDepartureTime(this, arrivalTime, egressPath, transferSlack, true);
    }

    default public int calculateEgressDepartureTimeWithoutTimeShift(int arrivalTime, RaptorAccessEgress egressPath, int transferSlack) {
        return TransitCalculator.calculateEgressDepartureTime(this, arrivalTime, egressPath, transferSlack, false);
    }

    private static int calculateEgressDepartureTime(TransitCalculator<?> calculator, int arrivalTime, RaptorAccessEgress egressPath, int transferSlack, boolean includeTimeShift) {
        int timeShiftedDepartureTime;
        int departureTime = arrivalTime;
        if (egressPath.hasRides()) {
            departureTime = calculator.plusDuration(departureTime, transferSlack);
        }
        int n = timeShiftedDepartureTime = calculator.searchForward() ? egressPath.earliestDepartureTime(departureTime) : egressPath.latestArrivalTime(departureTime);
        if (timeShiftedDepartureTime == -1999000000) {
            return -1999000000;
        }
        return includeTimeShift ? timeShiftedDepartureTime : departureTime;
    }
}

