/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.transit;

import java.util.Iterator;
import org.opentripplanner.framework.time.TimeUtils;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.SearchDirection;
import org.opentripplanner.raptor.api.request.RaptorTuningParameters;
import org.opentripplanner.raptor.api.request.SearchParams;
import org.opentripplanner.raptor.rangeraptor.transit.ForwardTransitCalculator;
import org.opentripplanner.raptor.rangeraptor.transit.RaptorTransitCalculator;
import org.opentripplanner.raptor.rangeraptor.transit.TripScheduleExactMatchSearch;
import org.opentripplanner.raptor.spi.IntIterator;
import org.opentripplanner.raptor.spi.RaptorConstrainedBoardingSearch;
import org.opentripplanner.raptor.spi.RaptorTimeTable;
import org.opentripplanner.raptor.spi.RaptorTransitDataProvider;
import org.opentripplanner.raptor.spi.RaptorTripScheduleSearch;
import org.opentripplanner.raptor.util.IntIterators;

public final class ForwardRaptorTransitCalculator<T extends RaptorTripSchedule>
extends ForwardTransitCalculator<T>
implements RaptorTransitCalculator<T> {
    private final int earliestDepartureTime;
    private final int searchWindowInSeconds;
    private final int latestAcceptableArrivalTime;
    private final int iterationStep;

    public ForwardRaptorTransitCalculator(SearchParams s, RaptorTuningParameters t) {
        this(s.earliestDepartureTime(), s.searchWindowInSeconds(), s.latestArrivalTime(), t.iterationDepartureStepInSeconds());
    }

    public ForwardRaptorTransitCalculator(int earliestDepartureTime, int searchWindowInSeconds, int latestAcceptableArrivalTime, int iterationStep) {
        this.earliestDepartureTime = earliestDepartureTime;
        this.searchWindowInSeconds = searchWindowInSeconds;
        this.latestAcceptableArrivalTime = latestAcceptableArrivalTime == -1999000000 ? this.unreachedTime() : latestAcceptableArrivalTime;
        this.iterationStep = iterationStep;
    }

    @Override
    public boolean exceedsTimeLimit(int time) {
        return this.isBefore(this.latestAcceptableArrivalTime, time);
    }

    @Override
    public String exceedsTimeLimitReason() {
        return "The arrival time exceeds the time limit, arrive to late: " + TimeUtils.timeToStrLong(this.latestAcceptableArrivalTime) + ".";
    }

    @Override
    public IntIterator rangeRaptorMinutes() {
        return this.oneIterationOnly() ? IntIterators.singleValueIterator(this.earliestDepartureTime) : IntIterators.intDecIterator(this.earliestDepartureTime + this.searchWindowInSeconds, this.earliestDepartureTime, this.iterationStep);
    }

    @Override
    public int minIterationDepartureTime() {
        return this.earliestDepartureTime;
    }

    @Override
    public boolean oneIterationOnly() {
        return this.searchWindowInSeconds <= this.iterationStep;
    }

    @Override
    public IntIterator patternStopIterator(int nStopsInPattern) {
        return IntIterators.intIncIterator(0, nStopsInPattern);
    }

    @Override
    public RaptorConstrainedBoardingSearch<T> transferConstraintsSearch(RaptorTransitDataProvider<T> transitData, int routeIndex) {
        return transitData.transferConstraintsForwardSearch(routeIndex);
    }

    @Override
    public Iterator<? extends RaptorTransfer> getTransfers(RaptorTransitDataProvider<T> transitDataProvider, int fromStop) {
        return transitDataProvider.getTransfersFromStop(fromStop);
    }

    @Override
    public RaptorTripScheduleSearch<T> createTripSearch(RaptorTimeTable<T> timeTable) {
        return timeTable.tripSearch(SearchDirection.FORWARD);
    }

    @Override
    public RaptorTripScheduleSearch<T> createExactTripSearch(RaptorTimeTable<T> pattern) {
        return new TripScheduleExactMatchSearch<T>(this.createTripSearch(pattern), this, this.iterationStep);
    }
}

