/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.transit;

import gnu.trove.map.TIntObjectMap;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.request.RaptorProfile;
import org.opentripplanner.raptor.rangeraptor.transit.AccessEgressFunctions;

public class EgressPaths {
    private final TIntObjectMap<List<RaptorAccessEgress>> pathsByStop;

    private EgressPaths(TIntObjectMap<List<RaptorAccessEgress>> pathsByStop) {
        this.pathsByStop = pathsByStop;
    }

    public static EgressPaths create(Collection<RaptorAccessEgress> paths, RaptorProfile profile) {
        if (!RaptorProfile.MULTI_CRITERIA.is(profile)) {
            paths = AccessEgressFunctions.removeNoneOptimalPathsForStandardRaptor(paths);
        }
        return new EgressPaths(AccessEgressFunctions.groupByStop(paths));
    }

    public TIntObjectMap<List<RaptorAccessEgress>> byStop() {
        return this.pathsByStop;
    }

    public int[] stops() {
        return this.pathsByStop.keys();
    }

    public Collection<RaptorAccessEgress> listAll() {
        return this.pathsByStop.valueCollection().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public int[] egressesWitchStartByWalking() {
        return this.filterPathsAndGetStops(RaptorAccessEgress::stopReachedByWalking);
    }

    public int[] egressesWitchStartByARide() {
        return this.filterPathsAndGetStops(RaptorAccessEgress::stopReachedOnBoard);
    }

    private int[] filterPathsAndGetStops(Predicate<RaptorAccessEgress> filter) {
        return this.pathsByStop.valueCollection().stream().flatMap(Collection::stream).filter(filter).mapToInt(RaptorAccessEgress::stop).distinct().toArray();
    }
}

