/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.transit;

import gnu.trove.map.TIntObjectMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.request.RaptorProfile;
import org.opentripplanner.raptor.rangeraptor.transit.AccessEgressFunctions;

public class AccessPaths {
    private final TIntObjectMap<List<RaptorAccessEgress>> arrivedOnStreetByNumOfRides;
    private final TIntObjectMap<List<RaptorAccessEgress>> arrivedOnBoardByNumOfRides;

    private AccessPaths(TIntObjectMap<List<RaptorAccessEgress>> arrivedOnStreetByNumOfRides, TIntObjectMap<List<RaptorAccessEgress>> arrivedOnBoardByNumOfRides) {
        this.arrivedOnStreetByNumOfRides = arrivedOnStreetByNumOfRides;
        this.arrivedOnBoardByNumOfRides = arrivedOnBoardByNumOfRides;
    }

    public TIntObjectMap<List<RaptorAccessEgress>> arrivedOnStreetByNumOfRides() {
        return this.arrivedOnStreetByNumOfRides;
    }

    public TIntObjectMap<List<RaptorAccessEgress>> arrivedOnBoardByNumOfRides() {
        return this.arrivedOnBoardByNumOfRides;
    }

    public int calculateMaxNumberOfRides() {
        return Math.max(Arrays.stream(this.arrivedOnStreetByNumOfRides.keys()).max().orElse(0), Arrays.stream(this.arrivedOnBoardByNumOfRides.keys()).max().orElse(0));
    }

    public static AccessPaths create(Collection<RaptorAccessEgress> paths, RaptorProfile profile) {
        if (!profile.is(RaptorProfile.MULTI_CRITERIA)) {
            paths = AccessEgressFunctions.removeNoneOptimalPathsForStandardRaptor(paths);
        }
        return new AccessPaths(AccessEgressFunctions.groupByRound(paths, RaptorAccessEgress::stopReachedByWalking), AccessEgressFunctions.groupByRound(paths, RaptorAccessEgress::stopReachedOnBoard));
    }

    public boolean hasTimeDependentAccess() {
        return AccessPaths.hasTimeDependentAccess(this.arrivedOnBoardByNumOfRides) || AccessPaths.hasTimeDependentAccess(this.arrivedOnStreetByNumOfRides);
    }

    private static boolean hasTimeDependentAccess(TIntObjectMap<List<RaptorAccessEgress>> map) {
        for (List list : map.valueCollection()) {
            if (!list.stream().anyMatch(RaptorAccessEgress::hasOpeningHours)) continue;
            return true;
        }
        return false;
    }
}

