/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.support;

import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.TransitArrival;
import org.opentripplanner.raptor.rangeraptor.internalapi.RoundProvider;
import org.opentripplanner.raptor.rangeraptor.internalapi.SlackProvider;
import org.opentripplanner.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.raptor.rangeraptor.transit.RaptorTransitCalculator;
import org.opentripplanner.raptor.spi.RaptorBoardOrAlightEvent;
import org.opentripplanner.raptor.spi.RaptorConstrainedBoardingSearch;
import org.opentripplanner.raptor.spi.RaptorTimeTable;
import org.opentripplanner.raptor.spi.RaptorTripScheduleSearch;

public final class TimeBasedBoardingSupport<T extends RaptorTripSchedule> {
    private final SlackProvider slackProvider;
    private final RaptorTransitCalculator<T> calculator;
    private final RoundProvider roundProvider;
    private final boolean hasTimeDependentAccess;
    private boolean inFirstIteration = true;
    private RaptorTimeTable<T> timeTable;
    private RaptorTripScheduleSearch<T> tripSearch;

    public TimeBasedBoardingSupport(boolean hasTimeDependentAccess, SlackProvider slackProvider, RaptorTransitCalculator<T> calculator, RoundProvider roundProvider, WorkerLifeCycle subscriptions) {
        this.hasTimeDependentAccess = hasTimeDependentAccess;
        this.slackProvider = slackProvider;
        this.calculator = calculator;
        this.roundProvider = roundProvider;
        subscriptions.onIterationComplete(() -> {
            this.inFirstIteration = false;
        });
    }

    public void prepareForTransitWith(RaptorTimeTable<T> timeTable) {
        this.timeTable = timeTable;
        this.tripSearch = this.createTripSearch(timeTable);
    }

    public RaptorBoardOrAlightEvent<T> searchRegularTransfer(int prevArrivalTime, int stopPos, int boardSlack) {
        return this.searchRegularTransfer(prevArrivalTime, stopPos, boardSlack, -1);
    }

    public RaptorBoardOrAlightEvent<T> searchRegularTransfer(int prevArrivalTime, int stopPos, int boardSlack, int onTripIndex) {
        int earliestBoardTime = this.earliestBoardTime(prevArrivalTime, boardSlack);
        return this.tripSearch.search(earliestBoardTime, stopPos, onTripIndex);
    }

    public RaptorBoardOrAlightEvent<T> searchConstrainedTransfer(TransitArrival<T> prevTransitStopArrival, int prevArrivalTime, int boardSlack, RaptorConstrainedBoardingSearch<T> txSearch) {
        if (prevTransitStopArrival == null) {
            return RaptorBoardOrAlightEvent.empty(this.earliestBoardTime(prevArrivalTime, boardSlack));
        }
        int prevTransitStopArrivalTime = prevTransitStopArrival.arrivalTime();
        int prevTransitArrivalTime = this.calculator.minusDuration(prevTransitStopArrivalTime, this.slackProvider.alightSlack(prevTransitStopArrival.trip().pattern().slackIndex()));
        int earliestBoardTime = this.earliestBoardTime(prevArrivalTime, boardSlack);
        return txSearch.find(this.timeTable, this.slackProvider.transferSlack(), prevTransitStopArrival.trip(), prevTransitStopArrival.stop(), prevTransitArrivalTime, earliestBoardTime);
    }

    private int earliestBoardTime(int prevArrivalTime, int boardSlack) {
        return this.calculator.plusDuration(prevArrivalTime, boardSlack);
    }

    private RaptorTripScheduleSearch<T> createTripSearch(RaptorTimeTable<T> timeTable) {
        if (!this.inFirstIteration && this.roundProvider.isFirstRound() && !this.hasTimeDependentAccess) {
            return this.calculator.createExactTripSearch(timeTable);
        }
        return this.calculator.createTripSearch(timeTable);
    }
}

