/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.standard.stoparrivals.path;

import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.framework.time.TimeUtils;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.view.ArrivalView;
import org.opentripplanner.raptor.rangeraptor.internalapi.SlackProvider;
import org.opentripplanner.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.raptor.rangeraptor.path.DestinationArrivalPaths;
import org.opentripplanner.raptor.rangeraptor.standard.internalapi.ArrivedAtDestinationCheck;
import org.opentripplanner.raptor.rangeraptor.standard.internalapi.DestinationArrivalListener;
import org.opentripplanner.raptor.rangeraptor.standard.stoparrivals.view.StopsCursor;
import org.opentripplanner.raptor.rangeraptor.transit.TransitCalculator;

public class EgressArrivalToPathAdapter<T extends RaptorTripSchedule>
implements ArrivedAtDestinationCheck,
DestinationArrivalListener {
    private final DestinationArrivalPaths<T> paths;
    private final TransitCalculator<T> calculator;
    private final SlackProvider slackProvider;
    private final StopsCursor<T> cursor;
    private final List<DestinationArrivalEvent> rejectedArrivals;
    private int bestDestinationTime = -1;
    private DestinationArrivalEvent bestArrival = null;

    public EgressArrivalToPathAdapter(DestinationArrivalPaths<T> paths, TransitCalculator<T> calculator, SlackProvider slackProvider, StopsCursor<T> cursor, WorkerLifeCycle lifeCycle) {
        this.paths = paths;
        this.calculator = calculator;
        this.slackProvider = slackProvider;
        this.cursor = cursor;
        this.rejectedArrivals = paths.isDebugOn() ? new ArrayList() : null;
        lifeCycle.onSetupIteration(ignore -> this.setupIteration());
        lifeCycle.onRoundComplete(ignore -> this.roundComplete());
    }

    @Override
    public void newDestinationArrival(int round, int fromStopArrivalTime, boolean stopReachedOnBoard, RaptorAccessEgress egressPath) {
        int egressDepartureTime = this.calculator.calculateEgressDepartureTime(fromStopArrivalTime, egressPath, this.slackProvider.transferSlack());
        if (egressDepartureTime == -1999000000) {
            return;
        }
        int arrivalTime = this.calculator.plusDuration(egressDepartureTime, egressPath.durationInSeconds());
        if (this.calculator.isBefore(arrivalTime, this.bestDestinationTime)) {
            this.debugRejectCurrentBestArrival();
            this.bestArrival = new DestinationArrivalEvent(round, stopReachedOnBoard, egressPath);
            this.bestDestinationTime = arrivalTime;
        } else {
            this.debugRejectNew(round, stopReachedOnBoard, egressPath);
        }
    }

    @Override
    public boolean arrivedAtDestinationCurrentRound() {
        return this.newElementSet();
    }

    private boolean newElementSet() {
        return this.bestArrival != null;
    }

    private void setupIteration() {
        this.bestArrival = null;
        this.bestDestinationTime = this.calculator.unreachedTime();
    }

    private void roundComplete() {
        if (this.newElementSet()) {
            this.addNewElementToPath();
            this.logDebugRejectEvents();
            this.bestArrival = null;
        }
    }

    private void addNewElementToPath() {
        this.paths.add(this.bestArrival.toArrivalState(this.cursor), this.bestArrival.egressPath);
    }

    private void debugRejectNew(int round, boolean stopReachedOnBoard, RaptorAccessEgress egressPath) {
        if (this.paths.isDebugOn()) {
            this.rejectedArrivals.add(new DestinationArrivalEvent(round, stopReachedOnBoard, egressPath));
        }
    }

    private void debugRejectCurrentBestArrival() {
        if (this.paths.isDebugOn() && this.newElementSet()) {
            this.rejectedArrivals.add(this.bestArrival);
        }
    }

    private void logDebugRejectEvents() {
        if (this.paths.isDebugOn()) {
            String reason = "Arrival time > " + TimeUtils.timeToStrCompact(this.bestDestinationTime);
            for (DestinationArrivalEvent it : this.rejectedArrivals) {
                this.paths.debugReject(it.toArrivalState(this.cursor), it.egressPath, reason);
            }
        }
    }

    private static class DestinationArrivalEvent {
        final int round;
        final boolean stopReachedOnBoard;
        final RaptorAccessEgress egressPath;

        private DestinationArrivalEvent(int round, boolean stopReachedOnBoard, RaptorAccessEgress egressPath) {
            this.round = round;
            this.stopReachedOnBoard = stopReachedOnBoard;
            this.egressPath = egressPath;
        }

        public String toString() {
            return ToStringBuilder.of(DestinationArrivalEvent.class).addNum("round", this.round).addBool("stopReachedOnBoard", this.stopReachedOnBoard).addObj("egressPath", this.egressPath).toString();
        }

        <T extends RaptorTripSchedule> ArrivalView<T> toArrivalState(StopsCursor<T> cursor) {
            return cursor.stop(this.round, this.egressPath.stop(), this.stopReachedOnBoard);
        }
    }
}

