/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.standard.heuristics;

import gnu.trove.map.TIntObjectMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntUnaryOperator;
import org.opentripplanner.framework.lang.IntUtils;
import org.opentripplanner.framework.time.TimeUtils;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.rangeraptor.internalapi.HeuristicAtStop;
import org.opentripplanner.raptor.rangeraptor.internalapi.Heuristics;
import org.opentripplanner.raptor.rangeraptor.internalapi.SingleCriteriaStopArrivals;
import org.opentripplanner.raptor.rangeraptor.transit.EgressPaths;
import org.opentripplanner.raptor.rangeraptor.transit.RaptorTransitCalculator;
import org.opentripplanner.raptor.rangeraptor.transit.TransitCalculator;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;

public class HeuristicsAdapter
implements Heuristics {
    private static final int NOT_SET = Integer.MAX_VALUE;
    private final SingleCriteriaStopArrivals bestOverallTimes;
    private final SingleCriteriaStopArrivals bestNumOfTransfers;
    private final TIntObjectMap<List<RaptorAccessEgress>> egressPaths;
    private final TransitCalculator<?> calculator;
    private final RaptorCostCalculator<?> costCalculator;
    private final int nStops;
    private final int originDepartureTime;
    private final AggregatedResults aggregatedResults;

    public HeuristicsAdapter(int nStops, EgressPaths egressPaths, RaptorTransitCalculator<?> calculator, RaptorCostCalculator<?> costCalculator, SingleCriteriaStopArrivals bestOverallTimes, SingleCriteriaStopArrivals bestTransitTimes, SingleCriteriaStopArrivals bestNTransfers) {
        this.nStops = nStops;
        this.egressPaths = egressPaths.byStop();
        this.calculator = calculator;
        this.costCalculator = costCalculator;
        this.bestOverallTimes = bestOverallTimes;
        this.bestNumOfTransfers = bestNTransfers;
        this.originDepartureTime = calculator.minIterationDepartureTime();
        this.aggregatedResults = AggregatedResults.create(calculator, this.originDepartureTime, bestOverallTimes, bestTransitTimes, bestNTransfers, this.egressPaths);
    }

    @Override
    public int[] bestTravelDurationToIntArray(int unreached) {
        return this.toIntArray(this.size(), unreached, this::bestTravelDuration);
    }

    @Override
    public int[] bestNumOfTransfersToIntArray(int unreached) {
        return this.toIntArray(this.size(), unreached, this::bestNumOfTransfers);
    }

    @Override
    public int[] bestGeneralizedCostToIntArray(int unreached) {
        return this.toIntArray(this.size(), unreached, this::bestGeneralizedCost);
    }

    @Override
    public HeuristicAtStop createHeuristicAtStop(int stop) {
        return this.reached(stop) ? new HeuristicAtStop(this.bestTravelDuration(stop), this.bestNumOfTransfers(stop), this.bestGeneralizedCost(stop)) : HeuristicAtStop.UNREACHED;
    }

    @Override
    public int size() {
        return this.nStops;
    }

    @Override
    public int bestOverallJourneyTravelDuration() {
        return this.aggregatedResults.minJourneyTravelDuration();
    }

    @Override
    public int bestOverallJourneyNumOfTransfers() {
        return this.aggregatedResults.minJourneyNumOfTransfers();
    }

    @Override
    public int minWaitTimeForJourneysReachingDestination() {
        return Math.abs(this.aggregatedResults.earliestArrivalTime() - this.originDepartureTime) - this.aggregatedResults.minJourneyTravelDuration();
    }

    public String toString() {
        return ToStringBuilder.of(Heuristics.class).addServiceTime("originDepartureTime(last iteration)", this.originDepartureTime).addObj("aggregatedResults", this.aggregatedResults).addCol("egress stops reached", Arrays.stream(this.egressPaths.keys()).filter(this.bestOverallTimes::isReached).mapToObj(s -> "[" + s + " " + TimeUtils.timeToStrCompact(this.bestOverallTimes.value(s)) + "]").limit(20L).toList()).toString();
    }

    private boolean reached(int stop) {
        return this.bestOverallTimes.isReached(stop);
    }

    private int bestTravelDuration(int stop) {
        return this.calculator.duration(this.originDepartureTime, this.bestOverallTimes.value(stop));
    }

    private int bestNumOfTransfers(int stop) {
        return this.bestNumOfTransfers.value(stop);
    }

    private int bestGeneralizedCost(int stop) {
        return this.costCalculator.calculateMinCost(this.bestTravelDuration(stop), this.bestNumOfTransfers(stop));
    }

    private int[] toIntArray(int size, int unreached, IntUnaryOperator supplier) {
        int[] a = IntUtils.intArray(size, unreached);
        for (int i = 0; i < a.length; ++i) {
            if (!this.reached(i)) continue;
            a[i] = supplier.applyAsInt(i);
        }
        return a;
    }

    private record AggregatedResults(int minJourneyTravelDuration, int minJourneyNumOfTransfers, int earliestArrivalTime) {
        private static AggregatedResults create(TransitCalculator<?> calculator, int originDepartureTime, SingleCriteriaStopArrivals bestOverallTimes, SingleCriteriaStopArrivals bestTransitTimes, SingleCriteriaStopArrivals bestNumOfTransfers, TIntObjectMap<List<RaptorAccessEgress>> egressPaths) {
            int bestJourneyTravelDuration = Integer.MAX_VALUE;
            int bestJourneyNumOfTransfers = Integer.MAX_VALUE;
            int bestArrivalTime = Integer.MAX_VALUE;
            for (int stop : egressPaths.keys()) {
                List list = (List)egressPaths.get(stop);
                boolean stopReached = bestOverallTimes.isReached(stop);
                boolean stopReachedByTransit = bestTransitTimes.isReached(stop);
                if (!stopReached) continue;
                int durationExEgress = calculator.duration(originDepartureTime, bestOverallTimes.value(stop));
                for (RaptorAccessEgress it : list) {
                    if (!it.stopReachedOnBoard() && !stopReachedByTransit) continue;
                    int d = durationExEgress + it.durationInSeconds();
                    bestJourneyTravelDuration = Math.min(bestJourneyTravelDuration, d);
                    int n = bestNumOfTransfers.value(it.stop());
                    bestJourneyNumOfTransfers = Math.min(bestJourneyNumOfTransfers, n);
                    int eat = bestOverallTimes.value(it.stop()) + it.durationInSeconds();
                    bestArrivalTime = Math.min(bestArrivalTime, eat);
                }
            }
            return new AggregatedResults(bestJourneyTravelDuration, bestJourneyNumOfTransfers, bestArrivalTime);
        }
    }
}

