/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.standard.debug;

import java.util.Collection;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.TransitArrival;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.rangeraptor.debug.DebugHandlerFactory;
import org.opentripplanner.raptor.rangeraptor.internalapi.RoundProvider;
import org.opentripplanner.raptor.rangeraptor.standard.debug.StateDebugger;
import org.opentripplanner.raptor.rangeraptor.standard.internalapi.StopArrivalsState;
import org.opentripplanner.raptor.rangeraptor.standard.stoparrivals.view.StopsCursor;

public final class DebugStopArrivalsState<T extends RaptorTripSchedule>
implements StopArrivalsState<T> {
    private final StopArrivalsState<T> delegate;
    private final StateDebugger<T> debug;

    public DebugStopArrivalsState(RoundProvider roundProvider, DebugHandlerFactory<T> dFactory, StopsCursor<T> stopsCursor, StopArrivalsState<T> delegate) {
        this.debug = new StateDebugger<T>(stopsCursor, roundProvider, dFactory);
        this.delegate = delegate;
    }

    @Override
    public void setAccessTime(int arrivalTime, RaptorAccessEgress access, boolean bestTime) {
        this.delegate.setAccessTime(arrivalTime, access, bestTime);
        this.debug.acceptAccessPath(access.stop(), access);
    }

    @Override
    public void rejectAccessTime(int arrivalTime, RaptorAccessEgress access) {
        this.debug.rejectAccessPath(access, arrivalTime);
        this.delegate.rejectAccessTime(arrivalTime, access);
    }

    @Override
    public int bestTimePreviousRound(int stop) {
        return this.delegate.bestTimePreviousRound(stop);
    }

    @Override
    public void setNewBestTransitTime(int stop, int alightTime, T trip, int boardStop, int boardTime, boolean newBestOverall) {
        this.debug.dropOldStateAndAcceptNewOnBoardArrival(stop, newBestOverall, () -> this.delegate.setNewBestTransitTime(stop, alightTime, (RaptorTripSchedule)trip, boardStop, boardTime, newBestOverall));
    }

    @Override
    public void rejectNewBestTransitTime(int stop, int alightTime, T trip, int boardStop, int boardTime) {
        this.debug.rejectTransit(stop, alightTime, trip, boardStop, boardTime);
        this.delegate.rejectNewBestTransitTime(stop, alightTime, trip, boardStop, boardTime);
    }

    @Override
    public void setNewBestTransferTime(int fromStop, int arrivalTime, RaptorTransfer transfer) {
        this.debug.dropOldStateAndAcceptNewOnStreetArrival(transfer.stop(), () -> this.delegate.setNewBestTransferTime(fromStop, arrivalTime, transfer));
    }

    @Override
    public void rejectNewBestTransferTime(int fromStop, int arrivalTime, RaptorTransfer transfer) {
        this.debug.rejectTransfer(fromStop, transfer, transfer.stop(), arrivalTime);
        this.delegate.rejectNewBestTransferTime(fromStop, arrivalTime, transfer);
    }

    @Override
    public TransitArrival<T> previousTransit(int boardStopIndex) {
        return this.delegate.previousTransit(boardStopIndex);
    }

    @Override
    public Collection<RaptorPath<T>> extractPaths() {
        return this.delegate.extractPaths();
    }
}

