/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.standard.configure;

import java.util.HashSet;
import java.util.Set;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.RelaxFunction;
import org.opentripplanner.raptor.api.request.RaptorProfile;
import org.opentripplanner.raptor.rangeraptor.context.SearchContext;
import org.opentripplanner.raptor.rangeraptor.internalapi.Heuristics;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorkerResult;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorkerState;
import org.opentripplanner.raptor.rangeraptor.internalapi.RoutingStrategy;
import org.opentripplanner.raptor.rangeraptor.path.DestinationArrivalPaths;
import org.opentripplanner.raptor.rangeraptor.path.PathParetoSetComparators;
import org.opentripplanner.raptor.rangeraptor.path.configure.PathConfig;
import org.opentripplanner.raptor.rangeraptor.standard.ArrivalTimeRoutingStrategy;
import org.opentripplanner.raptor.rangeraptor.standard.MinTravelDurationRoutingStrategy;
import org.opentripplanner.raptor.rangeraptor.standard.StdRangeRaptorWorkerState;
import org.opentripplanner.raptor.rangeraptor.standard.StdWorkerState;
import org.opentripplanner.raptor.rangeraptor.standard.besttimes.BestTimes;
import org.opentripplanner.raptor.rangeraptor.standard.besttimes.BestTimesOnlyStopArrivalsState;
import org.opentripplanner.raptor.rangeraptor.standard.besttimes.SimpleArrivedAtDestinationCheck;
import org.opentripplanner.raptor.rangeraptor.standard.besttimes.SimpleBestNumberOfTransfers;
import org.opentripplanner.raptor.rangeraptor.standard.besttimes.UnknownPathFactory;
import org.opentripplanner.raptor.rangeraptor.standard.configure.VerifyRequestIsValid;
import org.opentripplanner.raptor.rangeraptor.standard.debug.DebugStopArrivalsState;
import org.opentripplanner.raptor.rangeraptor.standard.heuristics.HeuristicsAdapter;
import org.opentripplanner.raptor.rangeraptor.standard.internalapi.ArrivedAtDestinationCheck;
import org.opentripplanner.raptor.rangeraptor.standard.internalapi.BestNumberOfTransfers;
import org.opentripplanner.raptor.rangeraptor.standard.internalapi.StopArrivalsState;
import org.opentripplanner.raptor.rangeraptor.standard.stoparrivals.StdStopArrivals;
import org.opentripplanner.raptor.rangeraptor.standard.stoparrivals.StdStopArrivalsState;
import org.opentripplanner.raptor.rangeraptor.standard.stoparrivals.path.EgressArrivalToPathAdapter;
import org.opentripplanner.raptor.rangeraptor.standard.stoparrivals.view.StopsCursor;

public class StdRangeRaptorConfig<T extends RaptorTripSchedule> {
    private final SearchContext<T> ctx;
    private final PathConfig<T> pathConfig;
    private final RoutingStrategy<T> strategy;
    private final Set<Class<?>> oneOfInstanceTypes = new HashSet();
    private RaptorWorkerState<T> state;
    private BestTimes bestTimes;
    private StdStopArrivals<T> stopArrivals;
    private ArrivedAtDestinationCheck arrivedAtDestinationCheck;
    private BestNumberOfTransfers bestNumberOfTransfers;

    public StdRangeRaptorConfig(SearchContext<T> context) {
        new VerifyRequestIsValid(context).verify();
        this.ctx = context;
        this.pathConfig = new PathConfig<T>(context);
        this.strategy = this.createWorkerStrategy();
    }

    public RaptorWorkerState<T> state() {
        return this.resolveState();
    }

    public RoutingStrategy<T> strategy() {
        return this.strategy;
    }

    public Heuristics createHeuristics(RaptorWorkerResult<T> results) {
        return this.oneOf(new HeuristicsAdapter(this.ctx.nStops(), this.ctx.egressPaths(), this.ctx.calculator(), this.ctx.costCalculator(), results.extractBestOverallArrivals(), results.extractBestTransitArrivals(), results.extractBestNumberOfTransfers()), Heuristics.class);
    }

    private RoutingStrategy<T> createWorkerStrategy() {
        return switch (this.ctx.profile()) {
            default -> throw new IncompatibleClassChangeError();
            case RaptorProfile.STANDARD, RaptorProfile.BEST_TIME -> new ArrivalTimeRoutingStrategy<T>(this.resolveState(), this.ctx.createTimeBasedBoardingSupport(), this.ctx.calculator());
            case RaptorProfile.MIN_TRAVEL_DURATION -> new MinTravelDurationRoutingStrategy<T>(this.resolveState(), this.ctx.createTimeBasedBoardingSupport(), this.ctx.calculator(), this.ctx.lifeCycle());
            case RaptorProfile.MULTI_CRITERIA -> throw new IllegalArgumentException(this.ctx.profile().toString());
        };
    }

    private StdRangeRaptorWorkerState<T> resolveState() {
        if (this.state == null) {
            this.state = this.oneOf(new StdRangeRaptorWorkerState<T>(this.ctx.calculator(), this.resolveBestTimes(), this.createStopArrivals(), this.resolveBestNumberOfTransfers(), this.resolveArrivedAtDestinationCheck()), StdWorkerState.class);
        }
        return (StdRangeRaptorWorkerState)this.state;
    }

    private BestTimes resolveBestTimes() {
        if (this.bestTimes == null) {
            this.bestTimes = new BestTimes(this.ctx.nStops(), this.ctx.calculator(), this.ctx.lifeCycle());
        }
        return this.bestTimes;
    }

    private StopArrivalsState<T> createStopArrivals() {
        return switch (this.ctx.profile()) {
            default -> throw new IncompatibleClassChangeError();
            case RaptorProfile.STANDARD -> this.stdStopArrivalsState();
            case RaptorProfile.BEST_TIME, RaptorProfile.MIN_TRAVEL_DURATION -> this.createBestTimeStopArrivalsState();
            case RaptorProfile.MULTI_CRITERIA -> throw new IllegalArgumentException(this.ctx.profile().toString());
        };
    }

    private StopArrivalsState<T> createBestTimeStopArrivalsState() {
        return this.oneOf(new BestTimesOnlyStopArrivalsState<T>(this.resolveBestTimes(), this.createSimpleBestNumberOfTransfers(), this.unknownPathFactory()), StopArrivalsState.class);
    }

    private StopArrivalsState<T> stdStopArrivalsState() {
        StdStopArrivalsState<T> state = this.oneOf(new StdStopArrivalsState<T>(this.resolveStopArrivals(), this.destinationArrivalPaths()), StopArrivalsState.class);
        return this.wrapStopArrivalsStateWithDebugger(state);
    }

    private StopArrivalsState<T> wrapStopArrivalsStateWithDebugger(StopArrivalsState<T> state) {
        if (this.ctx.debugFactory().isDebugStopArrival()) {
            return new DebugStopArrivalsState<T>(this.ctx.roundProvider(), this.ctx.debugFactory(), this.stopsCursor(), state);
        }
        return state;
    }

    private DestinationArrivalPaths<T> destinationArrivalPaths() {
        DestinationArrivalPaths<T> destinationArrivalPaths = this.pathConfig.createDestArrivalPathsWithoutGeneralizedCost();
        EgressArrivalToPathAdapter<T> pathsAdapter = this.createEgressArrivalToPathAdapter(destinationArrivalPaths);
        this.resolveStopArrivals().setupEgressStopStates(this.ctx.egressPaths(), pathsAdapter);
        return destinationArrivalPaths;
    }

    private EgressArrivalToPathAdapter<T> createEgressArrivalToPathAdapter(DestinationArrivalPaths<T> destinationArrivalPaths) {
        return this.withArrivedAtDestinationCheck(new EgressArrivalToPathAdapter<T>(destinationArrivalPaths, this.ctx.calculator(), this.ctx.slackProvider(), this.stopsCursor(), this.ctx.lifeCycle()));
    }

    private ArrivedAtDestinationCheck resolveArrivedAtDestinationCheck() {
        if (this.arrivedAtDestinationCheck == null) {
            this.withArrivedAtDestinationCheck(this.createSimpleArrivedAtDestinationCheck());
        }
        return this.arrivedAtDestinationCheck;
    }

    private StopsCursor<T> stopsCursor() {
        return new StopsCursor<T>(this.resolveStopArrivals(), this.ctx.calculator(), this.ctx.boardSlackProvider());
    }

    private StdStopArrivals<T> resolveStopArrivals() {
        if (this.stopArrivals == null) {
            this.stopArrivals = this.withBestNumberOfTransfers(this.oneOf(new StdStopArrivals(this.ctx.nRounds(), this.ctx.nStops(), this.ctx.roundProvider()), StdStopArrivals.class));
        }
        return this.stopArrivals;
    }

    private SimpleBestNumberOfTransfers createSimpleBestNumberOfTransfers() {
        return this.withBestNumberOfTransfers(new SimpleBestNumberOfTransfers(this.ctx.nStops(), this.ctx.roundProvider()));
    }

    private BestNumberOfTransfers resolveBestNumberOfTransfers() {
        if (this.bestNumberOfTransfers == null) {
            this.withBestNumberOfTransfers(this.createSimpleBestNumberOfTransfers());
        }
        return this.bestNumberOfTransfers;
    }

    private UnknownPathFactory<T> unknownPathFactory() {
        return this.oneOf(new UnknownPathFactory<T>(this.resolveBestTimes(), this.resolveBestNumberOfTransfers(), this.ctx.calculator(), this.ctx.slackProvider().transferSlack(), this.ctx.egressPaths(), RaptorProfile.MIN_TRAVEL_DURATION.is(this.ctx.profile()), PathParetoSetComparators.paretoComparator(false, this.ctx.searchParams().timetable(), this.ctx.searchParams().preferLateArrival(), this.ctx.searchDirection(), RelaxFunction.NORMAL), this.ctx.lifeCycle()), UnknownPathFactory.class);
    }

    private SimpleArrivedAtDestinationCheck createSimpleArrivedAtDestinationCheck() {
        return new SimpleArrivedAtDestinationCheck(this.resolveBestTimes(), this.ctx.egressPaths().egressesWitchStartByWalking(), this.ctx.egressPaths().egressesWitchStartByARide());
    }

    private <S extends BestNumberOfTransfers> S withBestNumberOfTransfers(S value) {
        this.bestNumberOfTransfers = this.oneOf(value, BestNumberOfTransfers.class);
        return value;
    }

    private <S extends ArrivedAtDestinationCheck> S withArrivedAtDestinationCheck(S value) {
        this.arrivedAtDestinationCheck = this.oneOf(value, ArrivedAtDestinationCheck.class);
        return value;
    }

    private <V> V oneOf(V instance, Class<?> ... types) {
        for (Class<?> type : types) {
            if (!type.isInstance(instance)) {
                throw new IllegalArgumentException("The instance of type " + instance.getClass().getSimpleName() + " is not an instance of type " + type.getSimpleName() + ".");
            }
            if (this.oneOfInstanceTypes.contains(type)) {
                throw new IllegalStateException("An instance for is already initialized for type: " + type.getSimpleName());
            }
            this.oneOfInstanceTypes.add(type);
        }
        return instance;
    }
}

