/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.standard.besttimes;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.raptor.rangeraptor.standard.besttimes.BestTimes;
import org.opentripplanner.raptor.rangeraptor.standard.internalapi.BestNumberOfTransfers;
import org.opentripplanner.raptor.rangeraptor.transit.EgressPaths;
import org.opentripplanner.raptor.rangeraptor.transit.TransitCalculator;
import org.opentripplanner.raptor.spi.UnknownPath;
import org.opentripplanner.raptor.util.paretoset.ParetoComparator;
import org.opentripplanner.raptor.util.paretoset.ParetoSet;

public class UnknownPathFactory<T extends RaptorTripSchedule> {
    private final BestTimes bestTimes;
    private final BestNumberOfTransfers bestNumberOfTransfers;
    private final TransitCalculator<T> transitCalculator;
    private final int transferSlack;
    private final List<RaptorAccessEgress> egressPaths;
    private final boolean skipTimeShiftEgressPaths;
    private final ParetoComparator<RaptorPath<T>> comparator;
    private int currentIterationDepartureTime;

    public UnknownPathFactory(BestTimes bestTimes, BestNumberOfTransfers bestNumberOfTransfers, TransitCalculator<T> transitCalculator, int transferSlack, EgressPaths egressPaths, boolean skipTimeShiftEgressPaths, ParetoComparator<RaptorPath<T>> comparator, WorkerLifeCycle lifeCycle) {
        this.bestTimes = bestTimes;
        this.bestNumberOfTransfers = bestNumberOfTransfers;
        this.transitCalculator = transitCalculator;
        this.transferSlack = transferSlack;
        this.egressPaths = List.copyOf(egressPaths.listAll());
        this.skipTimeShiftEgressPaths = skipTimeShiftEgressPaths;
        this.comparator = comparator;
        lifeCycle.onSetupIteration(this::setIterationDepartureTime);
    }

    private void setIterationDepartureTime(int value) {
        this.currentIterationDepartureTime = value;
    }

    public Collection<RaptorPath<T>> extractPaths() {
        ParetoSet<RaptorPath<T>> paths = new ParetoSet<RaptorPath<T>>(this.comparator);
        for (RaptorAccessEgress egress : this.egressPaths) {
            this.createNewPath(egress).ifPresent(paths::add);
        }
        return paths.stream().toList();
    }

    private Optional<RaptorPath<T>> createNewPath(RaptorAccessEgress egress) {
        int egressDepartureTime;
        int arrivalTime = this.calculateStopArrivalTime(egress);
        if (arrivalTime == -2111000000) {
            return Optional.empty();
        }
        int n = egressDepartureTime = this.skipTimeShiftEgressPaths ? this.transitCalculator.calculateEgressDepartureTimeWithoutTimeShift(arrivalTime, egress, this.transferSlack) : this.transitCalculator.calculateEgressDepartureTime(arrivalTime, egress, this.transferSlack);
        if (egressDepartureTime == -1999000000) {
            return Optional.empty();
        }
        int destinationArrivalTime = this.transitCalculator.plusDuration(egressDepartureTime, egress.durationInSeconds());
        int nTransfer = this.bestNumberOfTransfers.calculateMinNumberOfTransfers(egress.stop());
        return Optional.of(new UnknownPath(this.currentIterationDepartureTime, destinationArrivalTime, nTransfer += egress.numberOfRides()));
    }

    private int calculateStopArrivalTime(RaptorAccessEgress egress) {
        int stop = egress.stop();
        if (egress.stopReachedByWalking()) {
            if (this.bestTimes.isStopReachedByTransit(stop)) {
                return this.bestTimes.transitArrivalTime(stop);
            }
        } else if (this.bestTimes.isStopReached(stop)) {
            return this.bestTimes.time(stop);
        }
        return -2111000000;
    }
}

