/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.standard.besttimes;

import org.opentripplanner.raptor.rangeraptor.standard.besttimes.BestTimes;
import org.opentripplanner.raptor.rangeraptor.standard.internalapi.ArrivedAtDestinationCheck;

public class SimpleArrivedAtDestinationCheck
implements ArrivedAtDestinationCheck {
    private final int[] walkToDestinationEgressStops;
    private final int[] rideToDestinationEgressStops;
    private final BestTimes stopVisited;

    public SimpleArrivedAtDestinationCheck(BestTimes stopVisited, int[] walkToDestinationEgressStops, int[] rideToDestinationEgressStops) {
        this.stopVisited = stopVisited;
        this.walkToDestinationEgressStops = walkToDestinationEgressStops;
        this.rideToDestinationEgressStops = rideToDestinationEgressStops;
    }

    @Override
    public boolean arrivedAtDestinationCurrentRound() {
        for (int egressStop : this.walkToDestinationEgressStops) {
            if (!this.stopVisited.isStopReachedOnBoardInCurrentRound(egressStop)) continue;
            return true;
        }
        for (int egressStop : this.rideToDestinationEgressStops) {
            if (!this.stopVisited.isStopReachedInCurrentRound(egressStop)) continue;
            return true;
        }
        return false;
    }
}

