/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.standard;

import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.TransitArrival;
import org.opentripplanner.raptor.rangeraptor.internalapi.RoutingStrategy;
import org.opentripplanner.raptor.rangeraptor.standard.StdWorkerState;
import org.opentripplanner.raptor.rangeraptor.support.TimeBasedBoardingSupport;
import org.opentripplanner.raptor.rangeraptor.transit.TransitCalculator;
import org.opentripplanner.raptor.spi.RaptorBoardOrAlightEvent;
import org.opentripplanner.raptor.spi.RaptorConstrainedBoardingSearch;
import org.opentripplanner.raptor.spi.RaptorRoute;

public final class ArrivalTimeRoutingStrategy<T extends RaptorTripSchedule>
implements RoutingStrategy<T> {
    private static final int NOT_SET = -1;
    private final StdWorkerState<T> state;
    private final TimeBasedBoardingSupport<T> boardingSupport;
    private final TransitCalculator<T> calculator;
    private int onTripIndex;
    private int onTripBoardTime;
    private int onTripBoardStop;
    private T onTrip;

    public ArrivalTimeRoutingStrategy(StdWorkerState<T> state, TimeBasedBoardingSupport<T> boardingSupport, TransitCalculator<T> calculator) {
        this.state = state;
        this.boardingSupport = boardingSupport;
        this.calculator = calculator;
    }

    @Override
    public void setAccessToStop(RaptorAccessEgress accessPath, int departureTime) {
        this.state.setAccessToStop(accessPath, departureTime);
    }

    @Override
    public void prepareForTransitWith(RaptorRoute<T> route) {
        this.boardingSupport.prepareForTransitWith(route.timetable());
        this.onTripIndex = -1;
        this.onTripBoardTime = -1;
        this.onTripBoardStop = -1;
        this.onTrip = null;
    }

    @Override
    public void alightOnlyRegularTransferExist(int stopIndex, int stopPos, int alightSlack) {
        if (this.onTripIndex != -1) {
            int stopArrivalTime = this.calculator.stopArrivalTime(this.onTrip, stopPos, alightSlack);
            this.state.transitToStop(stopIndex, stopArrivalTime, this.onTripBoardStop, this.onTripBoardTime, this.onTrip);
        }
    }

    @Override
    public void alightConstrainedTransferExist(int stopIndex, int stopPos, int alightSlack) {
        this.alightOnlyRegularTransferExist(stopIndex, stopPos, alightSlack);
    }

    @Override
    public void boardWithRegularTransfer(int stopIndex, int stopPos, int boardSlack) {
        int prevArrivalTime = this.prevArrivalTime(stopIndex);
        RaptorBoardOrAlightEvent<T> boarding = this.boardingSupport.searchRegularTransfer(prevArrivalTime, stopPos, boardSlack, this.onTripIndex);
        if (!boarding.empty()) {
            this.board(stopIndex, boarding);
        }
    }

    @Override
    public void boardWithConstrainedTransfer(int stopIndex, int stopPos, int boardSlack, RaptorConstrainedBoardingSearch<T> txSearch) {
        this.boardingSupport.searchConstrainedTransfer(this.previousTransitArrival(stopIndex), this.prevArrivalTime(stopIndex), boardSlack, txSearch).boardWithFallback(boarding -> this.board(stopIndex, (RaptorBoardOrAlightEvent<T>)boarding), emptyBoarding -> this.boardWithRegularTransfer(stopIndex, stopPos, boardSlack));
    }

    private void board(int stopIndex, RaptorBoardOrAlightEvent<T> boarding) {
        this.onTripIndex = boarding.tripIndex();
        this.onTrip = boarding.trip();
        this.onTripBoardTime = boarding.time();
        this.onTripBoardStop = stopIndex;
    }

    private int prevArrivalTime(int stopIndex) {
        return this.state.bestTimePreviousRound(stopIndex);
    }

    private TransitArrival<T> previousTransitArrival(int boardStopIndex) {
        return this.state.previousTransit(boardStopIndex);
    }
}

