/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.path.configure;

import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.SearchDirection;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.api.path.RaptorStopNameResolver;
import org.opentripplanner.raptor.api.request.RaptorProfile;
import org.opentripplanner.raptor.rangeraptor.context.SearchContext;
import org.opentripplanner.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.raptor.rangeraptor.path.DestinationArrivalPaths;
import org.opentripplanner.raptor.rangeraptor.path.ForwardPathMapper;
import org.opentripplanner.raptor.rangeraptor.path.PathMapper;
import org.opentripplanner.raptor.rangeraptor.path.PathParetoSetComparators;
import org.opentripplanner.raptor.rangeraptor.path.ReversePathMapper;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.raptor.spi.RaptorPathConstrainedTransferSearch;
import org.opentripplanner.raptor.spi.RaptorSlackProvider;
import org.opentripplanner.raptor.util.paretoset.ParetoComparator;

public class PathConfig<T extends RaptorTripSchedule> {
    private final SearchContext<T> ctx;

    public PathConfig(SearchContext<T> context) {
        this.ctx = context;
    }

    public DestinationArrivalPaths<T> createDestArrivalPathsWithGeneralizedCost() {
        return this.createDestArrivalPaths(true);
    }

    public DestinationArrivalPaths<T> createDestArrivalPathsWithoutGeneralizedCost() {
        return this.createDestArrivalPaths(false);
    }

    private DestinationArrivalPaths<T> createDestArrivalPaths(boolean includeCost) {
        return new DestinationArrivalPaths<T>(this.createPathParetoComparator(includeCost), this.ctx.calculator(), includeCost ? this.ctx.costCalculator() : null, this.ctx.slackProvider(), this.createPathMapper(includeCost), this.ctx.debugFactory(), this.ctx.stopNameResolver(), this.ctx.lifeCycle());
    }

    private ParetoComparator<RaptorPath<T>> createPathParetoComparator(boolean includeCost) {
        return PathParetoSetComparators.paretoComparator(includeCost, this.ctx.searchParams().timetable(), this.ctx.searchParams().preferLateArrival(), this.ctx.searchDirection(), this.ctx.multiCriteria().relaxC1AtDestination());
    }

    private PathMapper<T> createPathMapper(boolean includeCost) {
        return PathConfig.createPathMapper(this.ctx.profile(), this.ctx.searchDirection(), this.ctx.raptorSlackProvider(), includeCost ? this.ctx.costCalculator() : null, this.ctx.stopNameResolver(), this.ctx.transit().transferConstraintsSearch(), this.ctx.lifeCycle());
    }

    private static <S extends RaptorTripSchedule> PathMapper<S> createPathMapper(RaptorProfile profile, SearchDirection searchDirection, RaptorSlackProvider slackProvider, RaptorCostCalculator<S> costCalculator, RaptorStopNameResolver stopNameResolver, RaptorPathConstrainedTransferSearch<S> txConstraintsSearch, WorkerLifeCycle lifeCycle) {
        return searchDirection.isForward() ? new ForwardPathMapper<S>(slackProvider, costCalculator, stopNameResolver, txConstraintsSearch, lifeCycle, profile.useApproximateTripSearch()) : new ReversePathMapper<S>(slackProvider, costCalculator, stopNameResolver, txConstraintsSearch, lifeCycle, profile.useApproximateTripSearch());
    }
}

